<form action="" id="convert-document" class="d-inline">
    <input type="hidden" name="destiny" value="invoice">
    <button type="submit" class="btn btn-sm btn-outline-info save ">@lang('Faturar')</button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Faturado')</button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Faturando')</button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
          $.validator.setDefaults({
            submitHandler: convertDocument
          });

          $('#convert-document').validate();
        });

        function convertDocument(){

            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
            });


            let data = $('form#convert-document').serializeArray();
            let invoiceCreate = "{{ URL::signedRoute('web.sales.invoice.create') }}"

            $.ajax({
                ...ajaxSettings,
                method: 'POST',
                url: "{{ URL::signedRoute('api.sales.proformas.copy', ['proforma' => $proforma->id]) }}",
                data: data,
                beforeSend: function () {
                    $('form#convert-document button.save').addClass('d-none');
                    $('form#convert-document button.saved').addClass('d-none');
                    $('form#convert-document button.error').addClass('d-none');
                    $('form#convert-document button.saving').removeClass('d-none');
                },
                statusCode: {
                    201: function (response) {
                        Toast.fire({
                            type: 'success',
                            title: '@lang("Document copied").'
                        })

                        $('form#convert-document button.save').addClass('d-none');
                        $('form#convert-document button.saved').removeClass('d-none');
                        $('form#convert-document button.saving').addClass('d-none');
                        $('form#convert-document button.error').addClass('d-none');
                        setTimeout(() => {
                            goto(invoiceCreate);
                        }, 3000)
                    },
                    401: (response) => {

                        Toast.fire({
                            type: 'error',
                            title: '@lang("Volte a fazer o login").'
                        })

                        $.ajax({
                            url: "{{ URL::signedRoute('web.system.exit') }}",
                            dataType: "HTML",
                            success: function (response) {
                                setTimeout(() => {
                                    reload();
                                }, 1500);
                            }
                        });
                    },
                    422: (response) => {
                        Toast.fire({
                            type: 'error',
                            title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                        })
                    },
                },
                error: (response) => {
                    $('form#convert-document button.save').addClass('d-none');
                    $('form#convert-document button.saved').addClass('d-none');
                    $('form#convert-document button.saving').addClass('d-none');
                    $('form#convert-document button.error').removeClass('d-none');
                    setTimeout(() => {
                        $('form#convert-document button.save').removeClass('d-none');
                        $('form#convert-document button.saved').addClass('d-none');
                        $('form#convert-document button.saving').addClass('d-none');
                        $('form#convert-document button.error').addClass('d-none');
                    }, 2000)
                }
            });
        }
</script>
@endpush
