<form action="" id="convert-document-to-prof" class="d-inline">
    <input type="hidden" name="destiny" value="proforma">
    <button type="submit" class="btn btn-sm btn-outline-info save ">@lang('Copy to proforma')</button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Copied')</button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Copying')</button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
          $.validator.setDefaults({
            submitHandler: convertDocument
          });

          $('#convert-document-to-prof').validate();
        });

        function convertDocument(){

            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000
            });


            let data = $('form#convert-document-to-prof').serializeArray();
            let invoiceCreate = "{{ URL::signedRoute('web.sales.proforma.create') }}"

            $.ajax({
                ...ajaxSettings,
                method: 'POST',
                url: "{{ URL::signedRoute('api.sales.proformas.copy', ['proforma' => $proforma->id]) }}",
                data: data,
                beforeSend: function () {
                    $('form#convert-document-to-prof button.save').addClass('d-none');
                    $('form#convert-document-to-prof button.saved').addClass('d-none');
                    $('form#convert-document-to-prof button.error').addClass('d-none');
                    $('form#convert-document-to-prof button.saving').removeClass('d-none');
                },
                statusCode: {
                    201: function (response) {
                        Toast.fire({
                            type: 'success',
                            title: '@lang("Document copied").'
                        })

                        $('form#convert-document-to-prof button.save').addClass('d-none');
                        $('form#convert-document-to-prof button.saved').removeClass('d-none');
                        $('form#convert-document-to-prof button.saving').addClass('d-none');
                        $('form#convert-document-to-prof button.error').addClass('d-none');
                        setTimeout(() => {
                            goto(invoiceCreate);
                        }, 3000)
                    },
                    401: (response) => {

                        Toast.fire({
                            type: 'error',
                            title: '@lang("Volte a fazer o login").'
                        })

                        $.ajax({
                            url: "{{ URL::signedRoute('web.system.exit') }}",
                            dataType: "HTML",
                            success: function (response) {
                                setTimeout(() => {
                                    reload();
                                }, 1500);
                            }
                        });
                    },
                    422: (response) => {
                        Toast.fire({
                            type: 'error',
                            title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                        })
                    },
                },
                error: (response) => {
                    $('form#convert-document-to-prof button.save').addClass('d-none');
                    $('form#convert-document-to-prof button.saved').addClass('d-none');
                    $('form#convert-document-to-prof button.saving').addClass('d-none');
                    $('form#convert-document-to-prof button.error').removeClass('d-none');
                    setTimeout(() => {
                        $('form#convert-document-to-prof button.save').removeClass('d-none');
                        $('form#convert-document-to-prof button.saved').addClass('d-none');
                        $('form#convert-document-to-prof button.saving').addClass('d-none');
                        $('form#convert-document-to-prof button.error').addClass('d-none');
                    }, 2000)
                }
            });
        }
</script>
@endpush
