<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Documento')</dt>
        <dd>{{ $proforma->name() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Data de emissão')</dt>
        <dd>{{ $proforma->issueDate() }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Operador')</dt>
        <dd>{{ $proforma->operator() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor total')</dt>
        <dd>{{ number_format($proforma->totalAmount(), 2) }}</dd>
    </div>
</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">

        <dt>@lang('Cliente')</dt>
        @if ($proforma->customer)
        <dd><a
                href="{{ URL::route('web.customer.show', ['customer'=>  $proforma->customer->id]) }}">{{ $proforma->customer_name }}</a>
        </dd>
        @else
        <dd>{{ $proforma->customer_name }}</dd>
        @endif
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('NUIT')</dt>
        <dd>{{ $proforma->customer_nuit }}</dd>
    </div>
</dl>

@include('sales.proforma.show.parts.mini.btn')


<div class="row">
    <div class="col-12 table-responsive">
        <table class="table table-sm table-body table-bordered my-1 mt-3">
            <thead class="">
                <tr>
                    <th class="text-left;">@lang('Codigo')</th>
                    <th class="text-left;">@lang('Artigo')</th>
                    <th class="text-left;">@lang('Quantidade')</th>
                    <th class="text-center">@lang('Preço')</th>
                    <th class="text-center">@lang('Desconto')</th>
                    <th class="text-center">@lang('IVA') %</th>
                    <th class="text-center">@lang('Subtotal')</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($proforma->saleItens as $item)
                <tr>
                    <td class="text-left">{{ $item->sale_code }}</td>
                    <td class="text-left">{{ $item->sale_name }}</td>
                    <td class="text-right">{{ number_format($item->quantity,  2) }}</td>
                    <td class="text-right">{{ number_format($item->unit_amount,  2) }}</td>
                    <td class="text-right">{{ number_format($item->discount, 2) }}</td>
                    <td class="text-right">{{ number_format($item->vat_tax, 2) }}</td>
                    <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@if ($proforma->obs !=null)

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> {{ $proforma->obs }}</p>
    </div>
</div>
@endif


<div class="row">
    <div class="col-12">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm">
                <thead>
                    <tr>
                        <td colspan="4"><b>@lang('Resumo de IVA')</b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b>@lang('Taxa')</b></td>
                        <td class="text-right"><b>@lang('Incidência')</b></td>
                        <td class="text-right"><b>@lang('Total IVA')</b></td>
                        <td class="text-right"><b>@lang('Motivo de isenção')</b></td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($proforma->vatResume() as $item)
                    <tr>
                        <td class="text-right">{{ $item->vat_tax }}</td>
                        <td class="text-right">{{ number_format($item->incidence, 2) }}</td>
                        <td class="text-right">{{ number_format($item->total, 2) }}</td>
                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="w-40 float-right mt-2">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td>@lang('Mercadoria ou serviços')</td>
                        <td class="text-right">{{ number_format($proforma->groceriesAndServices(),2) }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('Descontos comerciais')</td>
                        <td class="text-right">{{ number_format($proforma->commercialDiscount(), 2) }}</td>
                    </tr>

                    <tr class="">
                        <td>@lang('Desconto financeiro')</td>
                        <td class="text-right">{{ number_format($proforma->financial_discount) }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('IVA')</td>
                        <td class="text-right">{{ number_format($proforma->vatResume()->sum('total'), 2) }}</td>
                    </tr>
                    <tr>
                        <td>@lang('Total MZN')</td>
                        <td class="text-right">{{ number_format($proforma->totalAmount(), 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

    </div>

</div>
