<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">@lang('Informações da venda')</h3>
                </div>
                <div class="card-body">
                    <form role="form" id="create-receipt">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="gender">@lang('Cliente')</label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="customer">
                                    @foreach ($customers as $customer)
                                    <option value="{{ $customer->id }}" data-tokens="{{ $customer->code }}">
                                        {{ $customer->name }} </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="nuit">@lang('NUIT')</label>
                                <input type="text" name="nuit" class="form-control" id="nuit" placeholder="1500"
                                    value="0">
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="advance">@lang('Adiantamento Disponível')</label>
                                <input type="text" disabled name="advance" class="form-control" id="advance" placeholder="1"
                                    value="0">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="amount">@lang('Montante a pagar')</label>
                                <input type="text" name="amount" class="form-control" id="amount"
                                    placeholder="1500">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Pesquisar faturas')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Pesquisa terminada')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Pesquisando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        $.validator.setDefaults({
            submitHandler: getDocuments
        });

        $('#create-receipt').validate({
            rules: {
                amount: {
                    number:true,
                    min: 0
                },

            },
            messages: {
                quantity: {
                    required: 'Este campo é obrigatório',
                    min: 'Deve ser no mínimo zero'
                },
                discount: {
                    min: 'Deve ser no mínimo zero'
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


    $('select[name="customer"]').change(checkSelectedOption);
    $('input[name="amount"]').keypress(checkSelectedOption);

    $('form#create-receipt input[name="amount"]').on('keyup', checkSelectedOption);



    var customers = null;
    $(document).ready(getCustomers);
    function getCustomers() {
        $.ajax({
            type: "GET",
            url: "{{ URL::signedRoute('api.customer.index') }}",
            ...ajaxSettings,
            beforeSend: () => {
                $('form#create-receipt').hide();
            },
            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },
            success: function (response) {
                $('form#create-receipt').show();
                customers = response.data;
                checkSelectedOption();
            }
        });
    }

    function checkSelectedOption() {
        handlebar.init([]);
        let amount = $('form#create-receipt input[name="amount"]').val()
        $('input[name="amount"').attr('value', amount)

        const items = customers;
        const value = $('select[name="customer"]').val();

        let searcher = new Searchable(items)

        let customer = searcher.data(value);
        if (customer) {
            render(customer)
        }
    }

    function render(customer) {
        $('input[name="nuit"]').val(customer.nuit);
        $('input[name="advance"]').val(customer.advance);
    }

    function getDocuments() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });

        let data = $('form#create-receipt').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method: 'POST',
            url: "{{ URL::signedRoute('api.customer.search.bills')}}",
            data: data,
            beforeSend: function () {
                $('form#create-receipt button.save').addClass('d-none');
                $('form#create-receipt button.saved').addClass('d-none');
                $('form#create-receipt button.error').addClass('d-none');
                $('form#create-receipt button.saving').removeClass('d-none');
            },
            statusCode: {
                200: function (response) {
                    Toast.fire({
                        type: 'success',
                        title: '@lang("Search finished").'
                    })

                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                    documents = response.data
                    handlebar.init(response.data);
                },
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
                422: (response) => {
                    Toast.fire({
                        type: 'error',
                        title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                    })

                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                },
            },
            error: (response) => {
                $('form#create-receipt button.save').addClass('d-none');
                $('form#create-receipt button.saved').addClass('d-none');
                $('form#create-receipt button.saving').addClass('d-none');
                $('form#create-receipt button.error').removeClass('d-none');
                setTimeout(() => {
                    $('form#create-receipt button.save').removeClass('d-none');
                    $('form#create-receipt button.saved').addClass('d-none');
                    $('form#create-receipt button.saving').addClass('d-none');
                    $('form#create-receipt button.error').addClass('d-none');
                }, 2000)
            }
        });
    }
</script>
@endpush
