<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            @lang('Finalizar recibo')
        </h3>
    </div>
    <div class="card-body">
        @include('sales.receipt.create.parts.mini.finalize-btn')

        <div id="table"></div>
    </div>
</div>

@section('plugins.Handlebars', true)
<script id="table-template" type="text/x-handlebars-template">
    <table  class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th>@lang('Documento')</th>
                    <th>@lang('Tipo')</th>
                    <th>@lang('Valor Pendente')</th>
                    <th>@lang('Valor Total')</th>
                    <th>@lang('Apagar')</th>
                </tr>
            </thead>
            <tbody>
            @{{#each items }}
                <tr>
                    <td>@{{ this.name }}</td>
                    <td>@{{ this.type }}</td>
                    <td>@{{ this.pending }}</td>
                    <td>@{{ this.amount }}</td>

                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('@{{ this.id }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            @{{/each}}

            </tbody>
            <tfoot>
                    <tr>
                        <td colspan="4" class="text-right">@lang('Total')</td>
                        <td class="total"></td>
                    </tr>
            </tfoot>
        </table>
</script>
@push('js')

<script type="text/javascript">
    var documents = null;
    $(document).ready(loadItems);

    function loadItems(){
        handlebar.init([]);
    }

    function remove(id){
        documents = documents.filter((item) => {
            return item.id != id
        });
        handlebar.init(documents);
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();

                let total = 0
                list.forEach(element => {
                    total = total+ element.pending_unformated
                });
                $('td.total').html(total.toFixed(2));
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
@endpush
