<form role="form" class="mb-3" id="finalize-receipt">
    <input type="hidden" name="amount" value="0">
    <div class="row">
        <div class="form-group col-md-4">
            <label for="gender">@lang('Metodo de pagamento')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="6"
                data-live-search="false" name="payment_method">
                @foreach ($paymentMethods as $payment)
                <option value="{{ $payment->id }}" data-tokens="{{ $payment->id }}">
                    {{ $payment->name }} </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="bank_name">@lang('Nome do Banco')</label>
            <input type="text" name="bank_name" class="form-control" id="bank_name" placeholder="BCI" value="">
        </div>
        <div class="form-group col-sm-4">
            <label for="bank_document_nr">@lang('Número do Documento')</label>
            <input type="text" name="bank_document_nr" class="form-control" id="bank_document_nr" placeholder="BCI0001"
                value="">
        </div>

        <div class="form-group col-sm-12">
            <label for="bank_document_nr">@lang('Observação')</label>
            <textarea class="form-control" rows="2" name="obs" placeholder="Enter ..."></textarea>
        </div>
    </div>


    <div class="row">
        <div class="col-lg-12">
            <button type="button" class="btn btn-sm btn-outline-primary save ">@lang('Finalizar')</button>
            <button type="button" class="btn btn-sm btn-outline-info save-print">@lang('Finalizar e Imprimir')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>

        </div>
    </div>
</form>

@push('js')
<script type="text/javascript">
    var print = false;
$(document).on('click', 'form#finalize-receipt button.save', function (event) {
    print = false;
    finalizeSale()
    event.stopPropagation()
});
$(document).on('click', 'form#finalize-receipt button.save-print', function (event) {
    print = true;
    finalizeSale();
    event.stopPropagation()
});


function finalizeSale() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#finalize-receipt').serializeArray()

    let docs = documents.map(item =>{
        return {
            name: 'items[]',
            value: item.hash
        }
    })
    data = $.merge( docs, data )

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.sales.recipt.update', ['recipt'=> $recipt->id]) }}",
        data: data,
        beforeSend: function () {

            $('form#finalize-receipt button.save').addClass('d-none');
            $('form#finalize-receipt button.saved').addClass('d-none');
            $('form#finalize-receipt button.error').addClass('d-none');
            $('form#finalize-receipt button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#finalize-receipt button.save').addClass('d-none');
                $('form#finalize-receipt button.saved').removeClass('d-none');
                $('form#finalize-receipt button.saving').addClass('d-none');
                $('form#finalize-receipt button.error').addClass('d-none');


                if (print) {
                    goto('{{ URL::signedRoute('web.sales.recipt.print', ['recipt'=> $recipt->id]) }}')
                }  else{
                    reload()
                }

            },
            403: () => {
                reload();
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422:(response) =>{
                let message = response.responseJSON.message
                Toast.fire({
                    type: 'error',
                    title: message,

                })
            },
        },
        error: (response) => {
            $('form#finalize-receipt button.save').addClass('d-none');
            $('form#finalize-receipt button.saved').addClass('d-none');
            $('form#finalize-receipt button.saving').addClass('d-none');
            $('form#finalize-receipt button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-receipt button.save').removeClass('d-none');
                $('form#finalize-receipt button.saved').addClass('d-none');
                $('form#finalize-receipt button.saving').addClass('d-none');
                $('form#finalize-receipt button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush