<!DOCTYPE html>
<html>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    @include('sales.invoice.pdf.style')
</head>
@php
$company = $recipt->company;
$customer = $recipt->customer;
@endphp

<body style="font-size: 16px;">
    <div class="container-fluid">
        <div class="float-left w-60 text-left">

            <img src="{{ $company->logoPhoto() }}" width="150" style="object-fit: scale-down;" />

            <br><b>{{ $company->name }}</b><br>
            <b>{{ $company->nuit }}</b> <br>
            {{ $company->address }}<br>
            {{ $company->email }}<br>
            {{ $company->phone }}
            <br>
        </div>

        <div class="float-right w-40 text-right">
            <table class="table table-sm">
                <tbody>
                    <tr>
                        <td class="border-0 text-left"><b>@lang('Cliente') : </b></td>
                        <td class="border-0 text-right">{{ $customer->code }}</td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left">@lang('Nome') </td>
                        <td class="border-0 text-right">{{ $customer->name }}</td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left">@lang('NUIT')</td>
                        <td class="border-0 text-right">{{ $customer->nuit }}</td>
                    </tr>
                    <tr class="border-0 ">
                        <td class="border-0 text-left">@lang('Telefone')</td>
                        <td class="border-0 text-right">{{ $customer->phone }}</td>
                    </tr>

                    <tr>
                        <td class="border-0 text-right" colspan="2">{{ $customer->address }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">
        <div class="w-50 float-left mt-3">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td>@lang('Documento')</td>
                        <td class="text-right">
                            <b>@lang('Recibo')</b>
                        </td>
                    </tr>

                    <tr class="">
                        <td>@lang('Moeda')</td>
                        <td class="text-right">MZN</td>
                    </tr>
                    <tr>
                        <td>@lang('Data de emissao')</td>
                        <td class="text-right">{{ $recipt->validated_at->format('d/m/Y') }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('Operador')</td>
                        <td class="text-right">{{ $recipt->user->name }}</td>
                    </tr>
                </tbody>
            </table>
        </div>



        <div class="w-40 float-right mt-3">
            <table class="table text-bold table-sm text-right">
                <tbody>
                    <tr class="">
                        <td class="border-top-0">{{ $recipt->order() }}</td>
                    </tr>
                    <tr>
                        <td class="border-top-0"> {{ $recipt->name() }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="container-fluid">

        <div class="table-responsive">
            <table class="table table-sm table-body table-bordered mb-2">
                <thead class="">
                    <tr>
                        <th class="text-left;">@lang('Metodo de pagamento')</th>
                        <th class="text-left;">@lang('Banco')</th>
                        <th class="text-left">@lang('Número de documento bancário')</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-left">{{ $recipt->paymentMethod->name }}</td>
                        <td class="text-left">{{ $recipt->bankPayment()->exists()?$recipt->bankPayment->bank_name: '' }}
                        </td>
                        <td class="text-left">
                            {{ $recipt->bankPayment()->exists()?$recipt->bankPayment->document_nr: '' }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">

        <div class="table-responsive">
            <table class="table table-sm table-body table-bordered mb-1">
                <thead class="">
                    <tr>
                        <th class="text-left;">@lang('Documento')</th>
                        <th class="text-left;">@lang('Data de Emissão')</th>
                        <th class="text-center">@lang('Valor total')</th>
                        <th class="text-center">@lang('Valor pago')</th>
                        <th class="text-center">@lang('Valor pendente')</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($recipt->recieptItems as $item)
                    <tr>
                        @if ($item->mutate())
                            <td class="text-left">{{  $item->mutate()->code }}</td>
                            <td class="text-left">{{ $item->mutate()->validated_at->format('d/m/Y H:i') }}</td>
                            <td class="text-right">{{ number_format($item->mutate()->totalAmount(),  2) }}</td>
                        @endif

                        @if ($item->mutatebydelivery())
                            <td class="text-left">{{  $item->mutatebydelivery()->code }}</td>
                            <td class="text-left">{{ $item->mutatebydelivery()->validated_at->format('d/m/Y H:i') }}</td>
                            <td class="text-right">{{ number_format($item->mutatebydelivery()->totalAmount(),  2) }}</td>
                        @endif

                        <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                        <td class="text-right">{{ number_format($item->pending, 2) }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

           <table class="mt-3" style="display: none">
                <tr>
                    <td><sub>{{ config("app.name") }}, @lang('Licença')
                            <span class="text-bold text-sm">{{ config("app.finance_dep_global_auth") }}</span> /
                            {{ Auth::user()->brunch->daf_auth }} </sub></td>
                </tr>
            </table>
        </div>
    </div>

    <div class="container-fluid">
        <div class="w-50 float-left mt-2">
            <table class="table table-bordered table-sm d-none">
                <thead>
                    <tr>
                        <td colspan="4"><b>@lang('Resumo de IVA')</b>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-right"><b>@lang('Taxa')</b></td>
                        <td class="text-right"><b>@lang('Incidência')</b></td>
                        <td class="text-right"><b>@lang('Total IVA')</b></td>
                        <td class="text-right"><b>@lang('Motivo de isenção')</b></td>
                    </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
        <div class="w-40 float-right">
            <table class="table table-sm">
                <tbody>
                    <tr class="">
                        <td>@lang('Total usado')</td>
                        <td class="text-right">{{ number_format($recipt->recieptItems()->sum('amount'),2) }}</td>
                    </tr>
                    <tr class="">
                        <td>@lang('Total adiantado')</td>
                        <td class="text-right">{{ number_format($recipt->customerAdvance()->sum('amount'), 2) }}</td>
                    </tr>

                    <tr class="">
                        <td>@lang('Total pago')</td>
                        <td class="text-right">{{ number_format($recipt->amount, 2) }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>


    <div class="container-fluid">
        <table class="" width="100%">
            <tr>
                 <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; text-align: left; padding-top: 3mm; ">
                    <span class="d-none"> @lang('Pagina') . ' {PAGENO} ' .@lang('de') . ' {nb}</span>

                    <i>{{ config('app.name') }}, @lang('Licenciado a') <strong>{{$company->name}}</strong></i>

                    <br>
                    <sub> {{ config("app.finance_dep_global_auth") }}
                    </sub>
                    <br>
                    <sub>@lang('Processado por computador')</sub>
                </td>

                <td width="40%" class="text-right">
                    &nbsp;
                </td>

                <td width="30%"
                    style="border-top: 1px solid #000000; font-size: 9pt; padding-top: 3mm;  text-align: right;">
                    @lang('Impresso por'): {{ Auth::user()->name }}<br><span
                        style="font-size: 7pt;">{{ now()->format('d/m/Y') }}</span>
                </td>
            </tr>
        </table>
    </div>
</body>

</html>
