<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Documento')</dt>
        <dd>{{ $recipt->name() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Data de emissão')</dt>
        <dd>{{ $recipt->issueDate() }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Operador')</dt>
        <dd>{{ $recipt->operator() }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor total')</dt>
        <dd>{{ number_format($recipt->totalAmount(), 2) }}</dd>
    </div>
</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Cliente')</dt>
        @if ($recipt->customer)
        <dd><a
                href="{{ URL::route('web.customer.show', ['customer'=>  $recipt->customer->id]) }}">{{ $recipt->customer_name }}</a>
        </dd>
        @else
        <dd>{{ $recipt->customer_name }}</dd>
        @endif
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('NUIT')</dt>
        <dd>{{ $recipt->customer_nuit }}</dd>
    </div>
</dl>

@include('sales.receipt.show.parts.mini.btn')
<div class="row">
    <div class="table-responsive">
        <table class="table table-sm table-body table-bordered my-2">
            <thead class="">
                <tr>
                    <th class="text-left;">@lang('Metodo de pagamento')</th>
                    <th class="text-left;">@lang('Banco')</th>
                    <th class="text-left">@lang('Número de documento bancário')</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="text-left">{{ $recipt->paymentMethod->name }}</td>
                    <td class="text-left">{{ $recipt->bankPayment()->exists()?$recipt->bankPayment->bank_name: '' }}
                    </td>
                    <td class="text-left">{{ $recipt->bankPayment()->exists()?$recipt->bankPayment->document_nr: '' }}
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>


<div class="row">
    <div class="table-responsive">
        <table class="table table-sm table-body table-bordered my-1">
            <thead class="">
                <tr>
                    <th class="text-left;">@lang('Documento')</th>
                    <th class="text-left;">@lang('Data de Emissão')</th>
                    <th class="text-center">@lang('Valor total')</th>
                    <th class="text-center">@lang('Valor pago')</th>
                    <th class="text-center">@lang('Valor pendente')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($recipt->recieptItems as $item)
                <tr>
                    @if ($item->mutate())
                        <td class="text-left">{{  $item->mutate()->code }}</td>
                        <td class="text-left">{{ $item->mutate()->validated_at->format('d/m/Y H:i') }}</td>
                        <td class="text-right">{{ number_format($item->mutate()->totalAmount(),  2) }}</td>
                    @endif

                    @if ($item->mutatebydelivery())
                        <td class="text-left">{{  $item->mutatebydelivery()->code }}</td>
                        <td class="text-left">{{ $item->mutatebydelivery()->validated_at->format('d/m/Y H:i') }}</td>
                        <td class="text-right">{{ number_format($item->mutatebydelivery()->totalAmount(),  2) }}</td>
                    @endif

                    <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                    <td class="text-right">{{ number_format($item->pending, 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

@if ($recipt->obs !=null)

<div class="row">
    <div class="col-12 table-responsive">
        <p class="text-justify text-xs"><span class="text-bold">OBS: </span> {{ $recipt->obs }}</p>
    </div>
</div>
@endif
<div class="row">
    <div class="w-50 float-left mt-2">
        <table class="table  table-sm">
            <thead>
                <tr>
                    <td colspan="4"><b></b>
                    </td>
                </tr>

            </thead>
            <tbody>

            </tbody>
        </table>
    </div>
    <div class="w-50 float-right mt-2">
        <table class="table table-sm">
            <tbody>
                <tr class="">
                    <td>@lang('Total usado')</td>
                    <td class="text-right">{{ number_format($recipt->recieptItems()->sum('amount'),2) }}</td>
                </tr>
                <tr class="">
                    <td>@lang('Total adiantado')</td>
                    <td class="text-right">{{ number_format($recipt->customerAdvance()->sum('amount'), 2) }}</td>
                </tr>

                <tr class="">
                    <td>@lang('Total pago')</td>
                    <td class="text-right">{{ number_format($recipt->amount, 2) }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>
