<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">@lang('Informações CRM')</h3>
    </div>
    <div class="card-body">
        <form role="form" id="crm-search">
            <div class="form-group col-12">
                <label for="crm_customer">@lang('Cliente')</label>
                <input type="text" name="crm_customer" class="form-control" id="crm_customer" placeholder="Scan code">
            </div>

            <div class="form-group col-12">
                <label for="crm_customer_name">@lang('Nome')</label>
                <input type="text" name="crm_customer_name" disabled class="form-control" id="crm_customer_name"
                    placeholder="Não selecionado" value="">
            </div>

            <div class="form-group col-12">
                <label for="crm_points">@lang('Valor disponivel')</label>
                <input type="text" name="crm_points" disabled class="form-control" id="crm_points" placeholder="0"
                    value="">
            </div>
        </form>
    </div>
</div>

@push('js')
<script type="text/javascript">
    var customers = null;
    $(document).ready(getCustomers);
    function getCustomers() {
        $.ajax({
            type: "GET",
            url: "{{ URL::signedRoute('api.customer.index') }}",
            ...ajaxSettings,
            beforeSend: () => {
                $('form#crm-search').hide();
            },
            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },
            success: function (response) {
                $('form#crm-search').show();
                customers = response.data.length ? response.data : []
                searchCustomer('{{ md5(now()) }}')
            }
        });
    }

    function searchCustomer(id) {
        const items = customers;
        const value = id.toString().trim();

        let searcher = new Searchable(items)

        let customer = searcher.data(value, 'code');

        if (customer) {
            $('form#crm-search [name="crm_customer"]').val('');
            $('form#crm-search [name="crm_customer_name"]').val(customer.name);
            $('form#crm-search [name="crm_points"]').val(customer.crm.amount);
            $('form#finalize-basic [name="customer"]').val(value);
        }
        else{
            $('form#crm-search [name="crm_customer"]').val('');
            $('form#crm-search [name="crm_customer_name"]').val('');
            $('form#crm-search [name="crm_points"]').val('');
            $('form#finalize-basic [name="customer"]').val('');
        }
    }

    $(document).ready(function () {
        $('[name="crm_customer"]').keydown(function (e) {
            if (e.keyCode == 13) {
                searchCustomer( $('form#crm-search [name="crm_customer"]').val())
            }
        });
    });
</script>
@endpush