<form role="form" class="" id="finalize-basic">
    <div class="row">
        @if($crm)
        <div class="form-group col-sm-4 d-none">
            <label for="customer">@lang('Cliente')</label>
            <input type="text" name="customer" class="form-control" id="customer" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-4">
            <label for="pay_crm">@lang('Pagar com CRM')</label>
            <br>
            <input type="checkbox" class="bootstrap-switch form-control" name="pay_crm" data-bootstrap-switch
                data-off-color="danger" data-on-color="success" data-off-text="@lang('Não')"
                data-on-text="@lang('Sim')">
        </div>
        @endif
        <div class="form-group col-sm-4">
            <label for="shift">@lang('Turno')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                data-live-search="true" name="shift">
                @foreach ($shifts as $shift)
                <option value="{{ $shift->id }}" data-tokens="{{ $shift->code }}">
                    {{ $shift->id }} ({{ $shift->user->name }}) </option>
                @endforeach
            </select>
        </div>


        <div class="form-group col-sm-2">
            <label for="total">@lang('Total')</label>
            <input type="text" name="total" disabled class="form-control" id="total" placeholder="1500" value="">
        </div>

        <div class="form-group col-sm-4">
            <label for="paid">@lang('Pago')</label>
            <input type="text" name="paid" class="form-control" id="paid" placeholder="1500" value="0">
        </div>

        <div class="form-group col-sm-2">
            <label for="exchange">@lang('Troco')</label>
            <input type="text" disabled name="exchange" class="form-control" id="exchange" placeholder="1500" value="">
        </div>
    </div>


    <button type="button" class="btn btn-sm btn-outline-primary save ">@lang('Finalizar')</button>
    <button type="button" class="btn btn-sm btn-outline-info save-print">@lang('Finalizar e Imprimir')</button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
</form>

@push('js')
<script type="text/javascript">
    $('form#finalize-basic input[name="paid"]').on('keyup', function(){
        $('input[name="exchange"]').val(parseFloat($('form#finalize-basic input[name="paid"]').val()) - parseFloat(coast));
    });
</script>
@endpush

@push('js')
<script type="text/javascript">
    var print = false;
    $(document).on('click', 'form#finalize-basic button.save', function (event) {
        print = false;
        finalizeSale()
        event.stopPropagation()
    });
    $(document).on('click', 'form#finalize-basic button.save-print', function (event) {
        print = true;
        finalizeSale();
        event.stopPropagation()
    });

    function finalizeSale() {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        let data = $('form#finalize-basic').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method: 'PUT',
            url: "{{ URL::signedRoute('api.sales.returns.update', ['return'=> $return->id]) }}",
            data: data,
            beforeSend: function () {

                $('form#finalize-basic button.save').addClass('d-none');
                $('form#finalize-basic button.saved').addClass('d-none');
                $('form#finalize-basic button.error').addClass('d-none');
                $('form#finalize-basic button.saving').removeClass('d-none');
            },
            statusCode: {
                202: function (response) {
                    Toast.fire({
                        type: 'success',
                        title: '@lang("Entradas finalizadas").'
                    });

                    $('form#finalize-basic button.save').addClass('d-none');
                    $('form#finalize-basic button.saved').removeClass('d-none');
                    $('form#finalize-basic button.saving').addClass('d-none');
                    $('form#finalize-basic button.error').addClass('d-none');


                    if (print)
                        goto('{{ URL::signedRoute('web.sales.returns.print', ['return'=> $return->id]) }}')
                    else{
                        reload()
                    }

                },
                403: () => {
                    reload();
                },
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
                $('form#finalize-basic button.save').addClass('d-none');
                $('form#finalize-basic button.saved').addClass('d-none');
                $('form#finalize-basic button.saving').addClass('d-none');
                $('form#finalize-basic button.error').removeClass('d-none');
                setTimeout(() => {
                    $('form#finalize-basic button.save').removeClass('d-none');
                    $('form#finalize-basic button.saved').addClass('d-none');
                    $('form#finalize-basic button.saving').addClass('d-none');
                    $('form#finalize-basic button.error').addClass('d-none');
                }, 2000)
            }
        });
    }
</script>
@endpush
