<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            @lang('Finalizar')
        </h3>
    </div>
    <div class="card-body">
        @include('sales.returns.create.common.finalize-btn')
        <div id="table" class="mt-2"></div>
    </div>
</div>

@section('plugins.Handlebars', true)
<script id="table-template" type="text/x-handlebars-template">
    <table  class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th>@lang('Código')</th>
                    <th>@lang('Produto')</th>
                    <th>@lang('Quantidade')</th>
                    <th>@lang('Preço Unitário')</th>
                    <th>@lang('Desconto')</th>
                    <th>@lang('Preço total')</th>
                    <th>@lang('Apagar')</th>
                </tr>
            </thead>
            <tbody>
            @{{#each items }}
                <tr>
                    <td>@{{ this.code }}</td>
                    <td>@{{ this.name }}</td>
                    <td>@{{ this.quantity }}</td>
                    <td>@{{ this.unit_amount }}</td>
                    <td>@{{ this.discount }}</td>
                    <td>@{{ this.total }}</td>
                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('@{{ links.self }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            @{{/each}}

            </tbody>
        </table>
</script>
@push('js')

<script type="text/javascript">
    $(document).ready(loadItems);

    var coast = 0;

    function loadItems(){
        $.ajax({
            ...ajaxSettings,
            type: "GET",
            url: "{{ URL::signedRoute('api.sales.returns.show', ['return' => $return->id]) }}",
            dataType: "JSON",

            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },

            success: function (response) {
                coast = response.data.total_amount
                $('input[name="total"]').val(coast);
                handlebar.init(response.data.items);
            }
        });
    }
    function remove(url){
        $.ajax({
            ...ajaxSettings,
            type: "DELETE",
            url:url,
            dataType: "JSON",
            statusCode: {
                204: loadItems,
                401: (response) => {
                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
            },
        });
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
@endpush
