@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: addProduct
    });

    $('#create-basic-sale').validate({
        rules: {
            quantity: {
                required: true,
                min: 0
            },
            discount: {
                min: 0
            },
        },
        messages: {
            quantity: {
                required: 'Este campo é obrigatório',
                min: 'Deve ser no mínimo zero'
            },
            discount: {
                min: 'Deve ser no mínimo zero'
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });

});


$(document).ready(function () {
    $('[name="barcode"]').focus();
    $('[name="barcode"]').keydown(function (e) {
        if (e.keyCode == 13) {
            let val = $('[name="barcode"]').val();
            $('.selectpicker').val('');
            $('.selectpicker').selectpicker('deselectAll');
            const items = JSON.parse('{!! $saleables !!}')
            const value =  $('select[name="saleable"]').val();


            let saleable = items.filter(item => {
                return item.code == val
            });

            saleable =  saleable.length ? saleable[0] : null;

            if (saleable) {
                $('.selectpicker').val(saleable.id);
                $('.selectpicker').selectpicker('render');
            }


            $('[name="barcode"]').val('');



            // e.stopImmediatePropagation();
            // e.stopPropagation()
        }
    });
});

$(document).ready(checkSelectedOption);

$('select[name="saleable"]').change(checkSelectedOption);

function checkSelectedOption() {
    const items = JSON.parse('{!! $saleables !!}')
    const value =  $('select[name="saleable"]').val();

    let searcher = new Searchable(items)

    let saleable = searcher.data(value);
    if (saleable) {
        render(saleable)
    }
}

function render(saleable) {
    $('input[name="unit_amount"]').val(saleable.price);
    $('input[name="sale_name"]').val(saleable.name);
    $('input[name="sale_code"]').val(saleable.code);
    $('input[name="vat_tax"]').val(saleable.vat_scheme.tax);
}

function addProduct() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#create-basic-sale').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "{{ URL::signedRoute('api.sales.basic.item.store', ['basic' => $return->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#create-basic-sale button.save').addClass('d-none');
            $('form#create-basic-sale button.saved').addClass('d-none');
            $('form#create-basic-sale button.error').addClass('d-none');
            $('form#create-basic-sale button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Item added").'
                })

                $('form#create-basic-sale button.save').removeClass('d-none');
                $('form#create-basic-sale button.saved').addClass('d-none');
                $('form#create-basic-sale button.saving').addClass('d-none');
                $('form#create-basic-sale button.error').addClass('d-none');
                coast = response.body.total_amount
                $('input[name="total"]').val(coast);
                handlebar.init(response.body.items);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })

                $('form#create-basic-sale button.save').removeClass('d-none');
                $('form#create-basic-sale button.saved').addClass('d-none');
                $('form#create-basic-sale button.saving').addClass('d-none');
                $('form#create-basic-sale button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#create-basic-sale button.save').addClass('d-none');
            $('form#create-basic-sale button.saved').addClass('d-none');
            $('form#create-basic-sale button.saving').addClass('d-none');
            $('form#create-basic-sale button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#create-basic-sale button.save').removeClass('d-none');
                $('form#create-basic-sale button.saved').addClass('d-none');
                $('form#create-basic-sale button.saving').addClass('d-none');
                $('form#create-basic-sale button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
