<div class="container-fluid">
    <div class="row">
        <div class="col-md-{{ $crm? 9 : 12 }}">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">@lang('Informações da venda')</h3>
                </div>
                <div class="card-body">
                    <form role="form" id="create-basic-sale">
                        <input type="hidden" name="type" value="fast">
                        <div class="row">

                            <div class="form-group col-sm-2">
                                <label for="barcode">@lang('Scan Barcode')</label>
                                <input type="text" name="barcode" class="form-control" id="barcode" placeholder="1"
                                    value="1">
                            </div>

                            <div class="form-group col-sm-4">
                                <label for="gender">@lang('Produto')</label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4"
                                    data-live-search="true" name="saleable">
                                    @foreach ($saleables as $saleable)
                                    <option value="{{ $saleable->id }}" data-tokens="{{ $saleable->code }}">
                                        {{ $saleable->name }} </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-sm-2">
                                <label for="quantity">@lang('Quantidade')</label>
                                <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1"
                                    value="1">
                            </div>
                            <div class="form-group col-sm-4">
                                <label for="unit_amount">@lang('Preço unitário')</label>
                                <input type="text" name="unit_amount" class="form-control" id="unit_amount"
                                    placeholder="1500">
                            </div>
                         </div>

                        <div class="row">
                            <div class="col-12">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Adicionar')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Adicionado')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Adicionando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>

        @if($crm)
        <div class="col-md-3">
            @include('sales.returns.create.common.crm')
        </div>
        @endif
    </div>
</div>

@include('sales.returns.create.common.scripts')
