<!DOCTYPE html>
<html>

<head>
    <script type="text/javascript">
        window.print();
        window.onafterprint = back;

        function back() {
            window.history.back();
        }
    </script>

    <style type="text/css">
        @font-face {
            font-family: 'merchant_copy_doublesizeRg';
            font-weight: normal;
            font-style: normal;
        }
    </style>
    <style type="text/css">
        * {
            margin-right: 1px;
            padding: 0px;
            /* font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif */
            font-family: 'merchant_copy_doublesizeRg';
        }


        body {
            font-size: 11px;
        }

        table {
            border: 1px solid #ccc;
            width: 100%;
            text-align: center;
        }

        table tr {
            border: 1px solid #ccc;
        }




        table tfoot td {
            /* border-left: 2px solid; */
            border-top: 2px solid;
        }
    </style>

</head>

@php
$company = $shift->company;
@endphp

<body>
    <div style="margin: auto; width: 200px; text-align: center">
        <img src="{{ $company->logoPhoto() }}" width="80px" height="80px" style="object-fit: scale-down;"><br>
        <b>{{ $company->name }}</b><br>
        <b>Endereco: </b> {{ $company->address }}<br>
        <b>Nuit: </b> {{ $company->nuit }}<br>
        <b>Turno: {{ $shift->id }}</b><br>
        <b>Usuário:</b> {{ $shift->user->name }}
    </div>

    <div style="margin-top: 10px">
        <div style="width: 33%; float: left; text-align: left">
            <b>@lang('Abertura'): </b>
            {{ $shift->openedAt() }}
        </div>

        <div style="width: 33%; float: left; text-align: left">
            <b>@lang('Encerado'): </b>
            {{ $shift->closedAt() }}
        </div>

        <div style="width: 33%; float: left; text-align: left">
            <b>@lang('Duração'): </b>
            {{ $shift->duration() }} Horas
        </div>
    </div>

    <div style="margin-top: 10px">
        <div style="width: 45%; float: left; text-align: left">
            <b>@lang('Aberto por'): </b>
            {{ $shift->user->name }}
        </div>

        <div style="width: 45%; float: left; text-align: left">

            <b>@lang('Encerado por'): </b>
            {{ $shift->closedByUser? $shift->closedByUser->name : ''}}
        </div>

    </div>

    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;">@lang('Tipo')</th>
                    <th style=" text-align: right;">@lang('Valor')</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                @if ($shift->basicSales()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Venda Básicas')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->basicSales()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif

                @if ($shift->cashSales()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Venda dinheiro')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->cashSales()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif

                @if ($shift->invoices()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Faturas')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->invoices()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif


                @if ($shift->invoices()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Faturas/Guias')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->invoicesbydelivery()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif

                @if ($shift->deliveryNotes()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Guias de remessas')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->deliveryNotes()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif


                @if ($shift->debitNotes()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Notas de débito')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->debitNotes()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif


                @if ($shift->creditNotes()->exists())
                <tr>
                    <td style=" text-align: left;">@lang('Notas de crédito')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->creditNotes()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif


                @if ($shift->receipts()->exists())

                <tr>
                    <td style=" text-align: left;">@lang('Recibos')</td>
                    <td style=" text-align: right;">
                        {{ number_format($shift->sum($shift->receipts()->where('validated_at', '<>', null)->get()), 2) }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endif




            </tbody>

            <tfoot>
                <tr>

                    <td style="text-align: right; font-weight: bold;">@lang('Total de entradas'): </td>
                    <td colspan="1" style="text-align: right;">{{ number_format($shift->entries(), 2, ',', ' ') }} MZN
                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>

                <tr>
                    <td style="text-align: right; font-weight: bold;">@lang('Total de saídas'): </td>
                    <td colspan="1" style="text-align: right;">{{ number_format($shift->outputs(), 2, ',', ' ') }}
                        MZN</td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
            </tfoot>
        </table>
    </div>


    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;">@lang('Produto')</th>
                    <th style=" text-align: right;">@lang('Quantidade')</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($shift->saleables()->sortBy('name') as $saleable)
                <tr>
                    <td style=" text-align: left;">{{ $saleable->name }}</td>
                    <td style=" text-align: right;">
                        {{ number_format($saleable->sold_quantity, 2) }}
                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endforeach

            </tbody>
        </table>
    </div>

    @php
    $categories = $shift->categories();
    @endphp

    @if($categories->isNotEmpty())
    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th style=" text-align: left;">@lang('Categoria')</th>
                    <th style=" text-align: right;">@lang('Quantidade Vendida')</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($categories as $category)
                <tr>
                    <td style=" text-align: left;">{{ $category->name }}</td>

                    <td style=" text-align: right;">
                        {{ number_format($category->sold_quantity, 2) }}
                    </td>
                    <td>&nbsp;&nbsp;</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    @endif

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: left">
            @lang('Obrigado')<br />@lang('Volte sempre')

        </div>
    </div>


    <div style="margin-top: 20px">
        <div style="width: 100%; float: left; text-align: left">
            {{ config('app.name') }} &nbsp; v2.1<br />
            @lang('Operador'): <i>{{ request()->user()->name }}</i>
        </div>
    </div>

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: right">
            @lang('Assinature')<br /><br>@lang('____________________________')
        </div>
    </div>
</body>
<html>
