@section('plugins.Datatables', true)
@section('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@stop


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            @lang('Turnos')
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Usuário')</th>
                    <th>@lang('Abertura')</th>
                    <th>@lang('Fecho')</th>
                    <th>@lang('Encerrado por')</th>
                    <th>@lang('Duração')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($shifts as $shift)
                <tr ondblclick="goto('{{ URL::signedRoute('web.shift.show', ['shift'=>$shift->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $shift->id }}</td>
                    <td>{{ $shift->user->name }}</td>
                    <td>{{ $shift->started_at->format('H:i d/m/Y') }}</td>
                    <td>{{ $shift->isOpen()? __("Aberto") : $shift->ended_at->format('H:i d/m/Y')  }}</td>
                    <td>{{ $shift->isOpen()? '' : $shift->closedByUser->name  }}</td>
                    <td>{{ $shift->duration() }} Horas</td>

                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Usuário')</th>
                    <th>@lang('Abertura')</th>
                    <th>@lang('Fecho')</th>
                    <th>@lang('Encerrado por')</th>
                    <th>@lang('Duração')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>
