@extends('layouts.app')
@section('title', 'Detalhes de turno')

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>@lang('Detalhes de turno')</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.shift.index') }}">@lang('Turnos')</a></li>
                <li class="breadcrumb-item active">{{ md5($shift->id) }}</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">
            @include('shifts.shift.show.parts.basic')
        </div>

        @if (!Auth::user()->isJustSeller())
        <div class="col-md-9">
            @include('shifts.shift.show.parts.details')
        </div>
        @endif
    </div>
</div>
@endsection

@section('plugins.Datatables', true)
@section('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@stop