<form role="form" class="d-inline" id="close-shift">
    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Fechar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Fechado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Fechando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: closeShift
    });

    $('#close-shift').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});




function closeShift() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });



    let data = $('form#close-shift').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.shift.update', ['shift' => $shift->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#close-shift button.save').addClass('d-none');
            $('form#close-shift button.saved').addClass('d-none');
            $('form#close-shift button.error').addClass('d-none');
            $('form#close-shift button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Shift has been closed").'
                })

                $('form#close-shift button.save').addClass('d-none');
                $('form#close-shift button.saved').removeClass('d-none');
                $('form#close-shift button.saving').addClass('d-none');
                $('form#close-shift button.error').addClass('d-none');

                let current = {{ Route::currentRouteName() == 'web.shift.current'? 1 : 0 }}



                if(current){
                    let url =  "{{ URL::signedRoute('web.system.exit') }}"
                    goto(url);
                }
                else
                    reload();

            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })
            },
        },
        error: (response) => {
            $('form#close-shift button.save').addClass('d-none');
            $('form#close-shift button.saved').addClass('d-none');
            $('form#close-shift button.saving').addClass('d-none');
            $('form#close-shift button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#close-shift button.save').removeClass('d-none');
                $('form#close-shift button.saved').addClass('d-none');
                $('form#close-shift button.saving').addClass('d-none');
                $('form#close-shift button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
