<form role="form" id="create-category">
  <div class="row">
    <div class="form-group col-sm-4">
      <label for="name">@lang('Nome')</label>
      <input type="text" name="name" class="form-control" id="name" placeholder="Total Fuels">
    </div>

    <div class="form-group col-sm-8">
      <label for="description">@lang('Descrição')</label>
      <input type="text" name="description" class="form-control" id="description" placeholder="">
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
    </div>
  </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCategory
      });

      $('#create-category').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },

        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveCategory(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#create-category').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.stock.category.store') }}",
            data: data,
            beforeSend: function(){
              $('form#create-category button.save').addClass('d-none');
              $('form#create-category button.saved').addClass('d-none');
              $('form#create-category button.error').addClass('d-none');
              $('form#create-category button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Warehouse has been created").'
                  })

                  $('form#create-category button.save').addClass('d-none');
                  $('form#create-category button.saved').removeClass('d-none');
                  $('form#create-category button.saving').addClass('d-none');
                  $('form#create-category button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#create-category button.save').addClass('d-none');
              $('form#create-category button.saved').addClass('d-none');
              $('form#create-category button.saving').addClass('d-none');
              $('form#create-category button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-category button.save').removeClass('d-none');
                $('form#create-category button.saved').addClass('d-none');
                $('form#create-category button.saving').addClass('d-none');
                $('form#create-category button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
