@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.category.create') }}"
                class="btn btn-sm btn-outline-primary">@lang('Criar
                nova')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Produtos')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($categories as $category)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.category.show', ['category'=>$category->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $category->name }}</td>
                    <td>{{ $category->saleables()->count() }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Produtos')</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>