<form role="form" id="save-expense">
    <div class="row">

        <div class="form-group col-sm-6">
            <label for="amount">@lang('Valor')</label>
            <input type="text" name="amount" class="form-control" id="amount" placeholder="1">
        </div>

        <div class="form-group col-sm-6">
            <label for="reference">@lang('Referencia')</label>
            <input type="text" name="reference" class="form-control" id="reference" placeholder="FAT.2020">
        </div>

        <div class="form-group col-sm-12">
            <label for="description">@lang('Descrição')</label>
            <input type="text" name="description" class="form-control" id="description">
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>



@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveEntry
    });

    $('#save-expense').validate({
        rules: {

            amount: {
                required: true,
                min: 0
            },
            reference: {
                required: true,
            },
            description: {
            },



        },
        messages: {
            saleable: {
                required: 'Campo obrigatório',
            },
            amount: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            reference: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            description: {
            },
            warehouse: {
                required: 'Campo obrigatório',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(function () {
    $('.select2bs4').select2({
        theme: 'bootstrap4'
    })
});


function saveEntry() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#save-expense').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "{{ URL::signedRoute('api.stock.providers.expenses.store', ['provider' => $provider->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#save-expense button.save').addClass('d-none');
            $('form#save-expense button.saved').addClass('d-none');
            $('form#save-expense button.error').addClass('d-none');
            $('form#save-expense button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entrada provisoria guardada").'
                });

                $('form#save-expense button.save').addClass('d-none');
                $('form#save-expense button.saved').removeClass('d-none');
                $('form#save-expense button.saving').addClass('d-none');
                $('form#save-expense button.error').addClass('d-none');

                setTimeout(() => {
                    goto(response.url.web);
                }, 3000)
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })
            },
        },
        error: (response) => {
            $('form#save-expense button.save').addClass('d-none');
            $('form#save-expense button.saved').addClass('d-none');
            $('form#save-expense button.saving').addClass('d-none');
            $('form#save-expense button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#save-expense button.save').removeClass('d-none');
                $('form#save-expense button.saved').addClass('d-none');
                $('form#save-expense button.saving').addClass('d-none');
                $('form#save-expense button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
