@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.providers.expenses.create', ['provider'=> $provider->id ]) }}"
                class="btn btn-sm btn-outline-primary">@lang('Nova compra')</a>

            <a href="{{ URL::signedRoute('web.stock.providers.expenses.create', ['provider'=> $provider->id ]) }}"
                class="btn btn-sm btn-outline-primary">@lang('Registro de faturas')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Data')</th>
                    <th>@lang('Documento')</th>
                    <th>@lang('Total')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($expenses as $expense)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.providers.expenses.show', ['provider'=> $expense->provider->id , 'expense'=>$expense->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $expense->id }}</td>
                    <td>{{ $expense->validated_at?$expense->validated_at->format('Y/m/d'): '' }}</td>
                    <td>{{ $expense->reference }}</td>
                    <td>{{ number_format($expense->totalAmount(), 2) }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Data')</th>
                    <th>@lang('Documento')</th>
                    <th>@lang('Total')</th>
                    <th>@lang('Total Pago')</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>