@extends('layouts.app')
@section('title', $expense->reference)

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{ $expense->reference }}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a>
                </li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.index') }}">@lang('Fornecedores')</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.show', ['provider' => $provider->id]) }}">{{ $provider->name }}</a>
                </li>

                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.expenses.index', ['provider' => $provider->id]) }}">Faturas / Despesas</a>
                </li>
                <li class="breadcrumb-item active">{{ $expense->reference }}</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
@include('stock.provider.expenses.show.parts.tabs')
@endsection