<div class="row">
    <div class="col-12">
        <div class="card box-shadow-0 box-shadow collapsed-card border-0 border-radius-0">
            <div class="card-header">
                @if (!$expense->isPaid())
                <button type="submit" class="btn btn-sm btn-outline-info save"
                    data-card-widget="collapse">@lang('Pagar')</button>
                @endif

                <button type="submit" class="btn btn-sm btn-outline-danger save d-none">@lang('Anular')</button>
            </div>

            @if (!$expense->isPaid())
            <div class="card-body" style="display: none;">
                <form role="form" class="" id="pay-bill" method="post">

                    <div class="form-group row">

                        <div class="col-md-6">
                            <input type="text" name="reference" required placeholder="Documento de referencia"
                                class="form-control">
                        </div>

                        <div class="col-md-6 input-group">
                            <input type="text" name="amount" placeholder="valor a pagar" class="form-control">
                            <span class="input-group-append">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Pagar')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Pago')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Pagando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </span>
                        </div>
                    </div>
                </form>
            </div>
            @endif

        </div>
    </div>
</div>

@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: payBill
    });

    $('#pay-bill').validate({
        rules: {
            amount:{
                required:true,
                min:0,
                max:{{ $expense->pendingAmount() }},
            },
            reference:{
                required:true,
            },
        },
        messages:{
            amount: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido',
                max: 'Valor introduzido é inválido',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});


function payBill() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#pay-bill').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.stock.providers.expenses.pay', ['provider' => $provider->id, 'expense' => $expense->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#pay-bill button.save').addClass('d-none');
            $('form#pay-bill button.saved').addClass('d-none');
            $('form#pay-bill button.error').addClass('d-none');
            $('form#pay-bill button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {

                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#pay-bill button.save').addClass('d-none');
                $('form#pay-bill button.saved').removeClass('d-none');
                $('form#pay-bill button.saving').addClass('d-none');
                $('form#pay-bill button.error').addClass('d-none');
                setTimeout(() => {
                    goto(response.url.web)
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
        },
        error: (response) => {
            $('form#pay-bill button.save').addClass('d-none');
            $('form#pay-bill button.saved').addClass('d-none');
            $('form#pay-bill button.saving').addClass('d-none');
            $('form#pay-bill button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#pay-bill button.save').removeClass('d-none');
                $('form#pay-bill button.saved').addClass('d-none');
                $('form#pay-bill button.saving').addClass('d-none');
                $('form#pay-bill button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush