@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.providers.create') }}"
                class="btn btn-sm btn-outline-primary">@lang('Criar
                novo')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Contacto')</th>
                    <th>@lang('Responsável')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($providers as $provider)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.providers.show', ['provider'=>$provider->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $provider->name }}</td>
                    <td>{{ $provider->contact }}</td>
                    <td>{{ $provider->responsible   }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Contacto')</th>
                    <th>@lang('Responsável')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>