<form role="form" class="" id="finalize-moves">

    <div class="row">
        <div class="form-group col-sm-4">
            <label for="document">@lang('Número de Fatura')</label>
            <input type="text" name="document" class="form-control" id="document" placeholder="FA.002" value="">
        </div>

        <div class="form-group col-sm-2">
            <label for="total">@lang('Total')</label>
            <input type="text" name="total" disabled class="form-control" id="total" placeholder="0" value="">
        </div>


        <div class="form-group col-sm-3">
            <label for="financial_discount">@lang('Desconto financeiro')</label>
            <input type="text" name="financial_discount" class="form-control" id="financial_discount"
                placeholder="15000" value="">
        </div>


        <div class="form-group col-sm-3">
            <label for="ddd" class="text-white">@lang('Options')</label>
            <br>

            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Finalizar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Finalizado')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Finalizando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>


@section('plugins.JqueryValidation', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: finalizeMoves
    });

    $('#finalize-moves').validate({
        rules: {
            document:{
                required:true,
                minlength:2
            },

            financial_discount:{
                min:0
            }
        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});


function finalizeMoves() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#finalize-moves').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.stock.providers.purchases.update', ['provider' => $provider->id, 'purchase' => $purchase->id]) }}",
        data: data,
        beforeSend: function () {
            $('form#finalize-moves button.save').addClass('d-none');
            $('form#finalize-moves button.saved').addClass('d-none');
            $('form#finalize-moves button.error').addClass('d-none');
            $('form#finalize-moves button.saving').removeClass('d-none');
        },
        statusCode: {
            202: function (response) {

                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas finalizadas").'
                });

                $('form#finalize-moves button.save').addClass('d-none');
                $('form#finalize-moves button.saved').removeClass('d-none');
                $('form#finalize-moves button.saving').addClass('d-none');
                $('form#finalize-moves button.error').addClass('d-none');
                setTimeout(() => {
                    goto(response.url.web)
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
        },
        error: (response) => {
            $('form#finalize-moves button.save').addClass('d-none');
            $('form#finalize-moves button.saved').addClass('d-none');
            $('form#finalize-moves button.saving').addClass('d-none');
            $('form#finalize-moves button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#finalize-moves button.save').removeClass('d-none');
                $('form#finalize-moves button.saved').addClass('d-none');
                $('form#finalize-moves button.saving').addClass('d-none');
                $('form#finalize-moves button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
