<form role="form" id="creatte-move">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="gender">@lang('Produto')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" required data-size="4"
                data-live-search="true" name="saleable">
                @foreach ($saleables as $saleable)
                <option value="{{ $saleable->id }}" data-tokens="{{ $saleable->code }}"> {{ $saleable->name }}
                </option>
                @endforeach
            </select>
        </div>

        <input type="hidden" name="purchase" value="{{ $purchase->id }}">


        <div class="form-group col-sm-4">
            <label for="quantity">@lang('Quantidade')</label>
            <input type="text" name="quantity" class="form-control" id="quantity" placeholder="1">
        </div>

        <div class="form-group col-sm-4">
            <label for="price">@lang('Preço total')</label>
            <input type="text" name="price" class="form-control" id="price" placeholder="1500">
        </div>

        <div class="form-group col-sm-4">
            <label for="expirity_date">@lang('Data de validade')</label>
            <input type="date" name="expirity_date" class="form-control" id="expirity_date">
        </div>

        <div class="form-group col-sm-8">
            <label for="gender">@lang('Armazém de destino')</label>
            <select class="selectpicker form-control" data-style="btn-outline-primary" required data-size="4"
                name="warehouse">
                @foreach ($warehouses as $warehouse)
                <option value="{{ $warehouse->id }}"> {{ $warehouse->name }} </option>
                @endforeach
            </select>
        </div>


    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>



@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: saveEntry
    });

    $('#creatte-move').validate({
        rules: {
            saleable: {
                required: true,
            },
            quantity: {
                required: true,
                min: 0
            },
            price: {
                required: true,
                min: 0
            },
            expirity_date: {
                date: true
            },
            warehouse: {
                required: true,
            },


        },
        messages: {
            saleable: {
                required: 'Campo obrigatório',
            },
            quantity: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            price: {
                required: 'Campo obrigatório',
                min: 'Valor introduzido é inválido'
            },
            expirity_date: {
                date: 'Introduza uma data valida'
            },
            warehouse: {
                required: 'Campo obrigatório',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});

$(document).ready(function () {
    $('.select2bs4').select2({
        theme: 'bootstrap4'
    })
});


function saveEntry() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#creatte-move').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "{{ URL::signedRoute('api.stock.move.store') }}",
        data: data,
        beforeSend: function () {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.error').addClass('d-none');
            $('form#creatte-move button.saving').removeClass('d-none');
        },
        statusCode: {
            201: function (response) {
                handlebar.init(response.data);
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entrada provisoria guardada").'
                });

                $('form#creatte-move button.save').addClass('d-none');
                $('form#creatte-move button.saved').removeClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
                setTimeout(() => {
                    $('form#creatte-move button.save').removeClass('d-none');
                    $('form#creatte-move button.saved').addClass('d-none');
                    $('form#creatte-move button.saving').addClass('d-none');
                    $('form#creatte-move button.error').addClass('d-none');
                }, 3000);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })
            },
        },
        error: (response) => {
            $('form#creatte-move button.save').addClass('d-none');
            $('form#creatte-move button.saved').addClass('d-none');
            $('form#creatte-move button.saving').addClass('d-none');
            $('form#creatte-move button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#creatte-move button.save').removeClass('d-none');
                $('form#creatte-move button.saved').addClass('d-none');
                $('form#creatte-move button.saving').addClass('d-none');
                $('form#creatte-move button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
