@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush

@php
$purchases = $provider->purchases;
@endphp

<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.providers.purchases.create', ['provider'=> $provider->id ]) }}"
                class="btn btn-sm btn-outline-primary">@lang('Nova compra')</a>

            <a href="{{ URL::signedRoute('web.stock.providers.expenses.create', ['provider'=> $provider->id ]) }}"
                class="btn btn-sm btn-outline-primary">@lang('Registro de faturas')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Data')</th>
                    <th>@lang('Documento')</th>
                    <th>@lang('Total')</th>
                    <th>@lang('Total Pago')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($purchases as $purchase)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.providers.purchases.show', ['provider'=> $purchase->provider->id , 'purchase'=>$purchase->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $purchase->validated_at?$purchase->validated_at->format('Y/m/d'): '' }}</td>
                    <td>{{ $purchase->name }}</td>
                    <td>{{ number_format($purchase->totalAmount(), 2) }}</td>
                    <td>{{ number_format($purchase->totalAmountPaid(), 2) }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Data')</th>
                    <th>@lang('Documento')</th>
                    <th>@lang('Total')</th>
                    <th>@lang('Total Pago')</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>