@extends('layouts.app')
@section('title', $purchase->name)

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{ $purchase->name }}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a>
                </li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.index') }}">@lang('Fornecedores')</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.show', ['provider' => $provider->id]) }}">{{ $provider->name }}</a>
                </li>

                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.providers.purchases.index', ['provider' => $provider->id]) }}">@lang('Compras')</a>
                </li>
                <li class="breadcrumb-item active">{{ $purchase->name }}</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
@include('stock.provider.purchases.show.parts.tabs')
@endsection
