<dl class="row">

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Documento')</dt>
        <dd>{{ $purchase->name }}</dd>
    </div>
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Data de emissão')</dt>
        <dd>{{ $purchase->issueDate() }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Desconto financeiro')</dt>
        <dd>{{ number_format($purchase->financial_discount, 2) }} MZN</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Valor total')</dt>
        <dd>{{ number_format($purchase->totalAmount(), 2) }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>Valor Pendente</dt>
        <dd>{{ number_format($purchase->pendingAmount(), 2) }}</dd>
    </div>
</dl>

<dl class="row">
    <div class="col-sm-6 col-md-4">
        <dt>@lang('Fornecedor')</dt>
        <dd>{{ $purchase->provider->name }}</dd>
    </div>

    <div class="col-sm-6 col-md-4">
        <dt>@lang('Contacto')</dt>
        <dd>{{ $purchase->contact }}</dd>
    </div>
</dl>

@include('stock.provider.purchases.show.parts.mini.btn')


<div class="row">
    <div class="col-12 table-responsive">
        <table class="table table-sm table-body table-bordered my-1 mt-3">
            <thead class="">
                <tr>
                    <th class="text-left;">@lang('Codigo')</th>
                    <th class="text-left;">@lang('Artigo')</th>
                    <th class="text-center">@lang('Preço unitário')</th>
                    <th class="text-center">@lang('Quantidade')</th>
                    <th class="text-center">@lang('Subtotal')</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($purchase->stockMoves as $item)
                <tr>
                    <td class="text-left">{{ $item->saleable->code }}</td>
                    <td class="text-left">{{ $item->saleable->name }}</td>
                    <td class="text-right">{{ number_format($item->unit_price,  2) }}</td>
                    <td class="text-right">{{ number_format($item->quantity,  2) }}</td>
                    <td class="text-right">{{ number_format($item->totalAmount(), 2) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
