<form role="form" id="edit-provider">
  <div class="row">
    <div class="form-group col-sm-6">
      <label for="name">@lang('Nome')</label>
      <input type="text" name="name" class="form-control" id="name" value="{{ $provider->name }}"
        placeholder="Total Fuels">
    </div>

    <div class="form-group col-sm-6">
      <label for="contact">@lang('Contacto')</label>
      <input type="text" name="contact" class="form-control" id="contact" value="{{ $provider->contact }}"
        placeholder="8569874565">
    </div>

    <div class="form-group col-sm-4">
      <label for="responsible">@lang('Responsável')</label>
      <input type="text" name="responsible" class="form-control" id="responsible" value="{{ $provider->responsible }}"
        placeholder="15000">
    </div>

    <div class="form-group col-sm-4">
      <label for="address">@lang('Endereço')</label>
      <input type="text" name="address" class="form-control" id="address" value="{{ $provider->address }}"
        placeholder="Av.24 de Julho">
    </div>

    <div class="form-group col-sm-4">
      <label for="gender">@lang('Associar cliente')</label>
      <select class="selectpicker form-control" data-style="btn-outline-primary" data-size="4" data-live-search="true"
        name="customer">
        <option value="" data-tokens=""></option>
        @foreach ($customers as $customer)
        <option value="{{ $customer->id }}" data-tokens="{{ $customer->code }}" {{ $provider->is($customer->provider) ? 'selected' : '' }}>
          {{ $customer->name }} </option>
        @endforeach
      </select>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
    </div>
  </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)

@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveProvider
      });

      $('#edit-provider').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            contact:{
                required:true,
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            contact:{
                required:'Introduza o codigo do produto',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveProvider(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#edit-provider').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "{{ URL::signedRoute('api.stock.providers.update', ['provider' => $provider->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#edit-provider button.save').addClass('d-none');
              $('form#edit-provider button.saved').addClass('d-none');
              $('form#edit-provider button.error').addClass('d-none');
              $('form#edit-provider button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Provider has been updates").'
                  })

                  $('form#edit-provider button.save').addClass('d-none');
                  $('form#edit-provider button.saved').removeClass('d-none');
                  $('form#edit-provider button.saving').addClass('d-none');
                  $('form#edit-provider button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#edit-provider button.save').addClass('d-none');
              $('form#edit-provider button.saved').addClass('d-none');
              $('form#edit-provider button.saving').addClass('d-none');
              $('form#edit-provider button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-provider button.save').removeClass('d-none');
                $('form#edit-provider button.saved').addClass('d-none');
                $('form#edit-provider button.saving').addClass('d-none');
                $('form#edit-provider button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
