@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-body">
        <table id="table" class="sb-datatable table-sm table table-bordered table-striped display  no-search compact">
            <thead>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Data')</th>
                    <th>@lang('Referencia')</th>
                    <th  class="text-right">@lang('Credito')</th>
                    <th  class="text-right">@lang('Debito')</th>
                    <th  class="text-right">@lang('Saldo')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($operations as $operation)
                <tr ondblclick="goto('{{ $operation->webLink() }}')" class="cursor-pointer {{ $operation->morth->isPayment()? 'bg-danger' : '' }} {{ !$operation->isPaid()? 'bg-warning' : '' }}" >
                    <td>{{ $operation->id }}</td>
                    <td>{{ $operation->validated_at?$operation->validated_at->format('Y/m/d'): '' }}</td>
                    <td>{{ $operation->reference()}}</td>
                    <td class="text-right">{{ number_format($operation->credit(), 2) }}</td>
                    <td class="text-right">{{ number_format($operation->debit(), 2) }}</td>
                    <td class="text-right">{{ number_format($operation->postBalance(), 2) }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('ID')</th>
                    <th>@lang('Data')</th>
                    <th>@lang('Referencia')</th>
                    <th class="text-right">@lang('Credito')</th>
                    <th class="text-right">@lang('Debito')</th>
                    <th class="text-right">@lang('Saldo')</th>
                </tr>
            </tfoot>
        </table>
    </div>
</div>