@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.saleable.create') }}"
                class="btn btn-sm btn-outline-primary">@lang('Criar
                novo')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Codigo')</th>
                    <th>@lang('Unidade')</th>
                    <th>@lang('Preço')</th>
                    <th>@lang('Regime de IVA')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($saleables as $saleable)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.saleable.show', ['saleable'=>$saleable->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $saleable->name }}</td>
                    <td>{{ $saleable->code }}</td>
                    <td>{{ $saleable->saleUnit->name }}</td>
                    <td>{{ number_format($saleable->price, 2) }}</td>
                    <td>{{ $saleable->vatScheme->name   }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Codigo')</th>
                    <th>@lang('Unidade')</th>
                    <th>@lang('Preço')</th>
                    <th>@lang('Regime de IVA')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>