<form role="form" id="edit-saleable">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="name">@lang('Nome')</label>
            <input type="text" name="name" class="form-control" id="name" placeholder="Mouse Optico"
                value="{{ $saleable->name }}">
        </div>

        <div class="form-group col-sm-4">
            <label for="code">@lang('Codigo')</label>
            <input type="text" name="code" class="form-control" id="code" placeholder="125896321"
                value="{{ $saleable->code }}">
        </div>

        <div class="form-group col-sm-4">
            <label for="vat_scheme">@lang('Regime de IVA')</label>
            <select name="vat_scheme" class="form-control select2bs4" style="width: 100%;"
                data-placeholder="@lang('Seleciona regime da empresa')">
                @foreach ($vatschemes as $scheme)
                <option value="{{ $scheme->id }}" {{ $scheme->is($saleable->vatScheme)? 'selected': '' }}>
                    {{ $scheme->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="sale_unit">@lang('Unidade de venda')</label>
            <select name="sale_unit" class="form-control select2bs4" style="width: 100%;"
                data-placeholder="@lang('Seleciona a unidade de venda')">
                @foreach ($saleunits as $unit)
                <option value="{{ $unit->id }}" {{ $unit->is($saleable->saleUnit)? 'selected': '' }}>{{ $unit->name }}
                </option>
                @endforeach
            </select>
        </div>

        <div class="form-group col-sm-4">
            <label for="price">@lang('Preço unitário')</label>
            <input type="text" name="price" class="form-control" id="price" placeholder="15000"
                value="{{ $saleable->price }}">
        </div>

        <div class="form-group col-sm-4">
            <label for="price">@lang('Usa Stock')</label>
            <br>

            <input type="checkbox" class="bootstrap-switch form-control" name="stockable" {!! $saleable->is_stockable?
            'checked': '' !!} data-bootstrap-switch
            data-off-color="danger" data-on-color="success">
        </div>

        <div class="form-group col-sm-12">
            <label for="description">@lang('Descrição')</label>
            <textarea class="form-control" name="description" id="description"
                rows="3">{{ $saleable->description }}</textarea>
        </div>

        <div class="form-group col-sm-12">
            <label for="gender">@lang('Categorias')</label>
            <select class="select2bs4" name="categories[]" multiple="multiple"
                data-placeholder="@lang('Selecione as categorias do produto')" style="width: 100%;">
                @foreach ($categories as $category)
                <option value="{{ $category->id }}" {{ $saleable->hasCategory($category)? 'selected': '' }}>
                    {{ $category->name }} </option>
                @endforeach
            </select>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.Sweetalert2', true)
@section('plugins.BootstrapSwitch', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#edit-saleable').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            code:{
                required:true,
            },
            price:{
                required:true,
                min:0
            },
            description:{
                required:false,
                minlength:2
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            code:{
                required:'Introduza o codigo do produto',
            },
            price:{
                required: 'introduza o preço do item.',
                min: 'O preço minimo deve se 0'
            },
            description:{
                minlength:'Por favor introduza o telefone da empresa',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-saleable').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "{{ URL::route('api.stock.saleable.update', ['saleable'=>$saleable->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#edit-saleable button.save').addClass('d-none');
              $('form#edit-saleable button.saved').addClass('d-none');
              $('form#edit-saleable button.error').addClass('d-none');
              $('form#edit-saleable button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Product has been edited").'
                  })

                  $('form#edit-saleable button.save').addClass('d-none');
                  $('form#edit-saleable button.saved').removeClass('d-none');
                  $('form#edit-saleable button.saving').addClass('d-none');
                  $('form#edit-saleable button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::route('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#edit-saleable button.save').addClass('d-none');
              $('form#edit-saleable button.saved').addClass('d-none');
              $('form#edit-saleable button.saving').addClass('d-none');
              $('form#edit-saleable button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-saleable button.save').removeClass('d-none');
                $('form#edit-saleable button.saved').addClass('d-none');
                $('form#edit-saleable button.saving').addClass('d-none');
                $('form#edit-saleable button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
