<div class="table-wrapper">

    <div id="table" class="card-body">


    </div>
</div>
@section('plugins.Handlebars', true)
@section('plugins.Datatables', true)
@section('plugins.DatatablesExport', true)


<script id="table-template" type="text/x-handlebars-template">
    <table class="mucassa-datatable export excel table no-search table-bordered table-striped display compact">
        <thead>
            <tr>
                <th>@lang('Codigo')</th>
                <th>@lang('Armazem')</th>
                <th>@lang('Produto')</th>
                <th>@lang('Quantidade')</th>
                <th>@lang('Saldo')</th>
                <th>@lang('Custo total')</th>
                <th>@lang('Fornecedor')</th>
                <th>@lang('Data de entrada')</th>
                <th>@lang('Data de validade')</th>
                <th>@lang('Usuário')</th>
            </tr>
        </thead>
        <tbody>
        @{{#each items }}
            <tr>
                <td>@{{ this.id }}</td>
                <td>@{{ this.warehouse }}</td>
                <td>@{{ this.saleable }}</td>
                <td>@{{ this.quantity }}</td>
                <td>@{{ this.balance }}</td>
                <td>@{{ this.price }}</td>
                <td>@{{ this.provider }}</td>
                <td>@{{ this.validated_at }}</td>
                <td>@{{ this.expirity_date }}</td>
                <td>@{{ this.user }}</td>
            </tr>
        @{{/each}}

        </tbody>
    </table>
</script>

@push('js')
<script type="text/javascript">
    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            var template = Handlebars.compile($("#table-template").html());
            var context = {
                'items': list
            };
            var html = template(context);
            this.$tableContainer.html(html);

            initDatatable();

            if (list.length) {
                this.$tableContainer.parents('.table-wrapper').show();
            } else {
                this.$tableContainer.parents('.table-wrapper').hide();
            }
        },
    };

</script>
@endpush