<form role="form" id="create-saleunit">
    <div class="row">
      <div class="form-group col-sm-6">
        <label for="name">@lang('Nome')</label>
        <input type="text" name="name" class="form-control" id="name" placeholder="Units">
      </div>

      <div class="form-group col-sm-6">
        <label for="abbr">@lang('Abreviação')</label>
        <input type="text" name="abbr" class="form-control" id="abbr" placeholder="UN">
      </div>
    </div>


  <div class="row">
    <div class="col-12">
      <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
      <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
      <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
          class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
      <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
    </div>
  </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#create-saleunit').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            contact:{
                required:true,
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            contact:{
                required:'Introduza o codigo do produto',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#create-saleunit').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.stock.saleunit.store') }}",
            data: data,
            beforeSend: function(){
              $('form#create-saleunit button.save').addClass('d-none');
              $('form#create-saleunit button.saved').addClass('d-none');
              $('form#create-saleunit button.error').addClass('d-none');
              $('form#create-saleunit button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Saleunit has been created").'
                  })

                  $('form#create-saleunit button.save').addClass('d-none');
                  $('form#create-saleunit button.saved').removeClass('d-none');
                  $('form#create-saleunit button.saving').addClass('d-none');
                  $('form#create-saleunit button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#create-saleunit button.save').addClass('d-none');
              $('form#create-saleunit button.saved').addClass('d-none');
              $('form#create-saleunit button.saving').addClass('d-none');
              $('form#create-saleunit button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-saleunit button.save').removeClass('d-none');
                $('form#create-saleunit button.saved').addClass('d-none');
                $('form#create-saleunit button.saving').addClass('d-none');
                $('form#create-saleunit button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
