@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.saleunit.create') }}"
                class="btn btn-sm btn-outline-primary">@lang('Criar
                novo')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Abreviação')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($saleunits as $saleunit)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.saleunit.show', ['saleunit'=>$saleunit->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $saleunit->name }}</td>
                    <td>{{ $saleunit->abbr }}</td>
                </tr>
                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Abreviação')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>