<form role="form" class="mt-1" id="delete-saleunit">
  <button type="submit" class="btn btn-sm btn-outline-danger save">@lang('Apagar')</button>
  <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Apagado')</button>
  <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
      class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Apagando')</button>
  <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)

@push('js')
<script type="text/javascript">
  $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: dletesaleunit
      });

      $('#delete-saleunit').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    function dletesaleunit(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#delete-saleunit').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'DELETE',
            url: "{{ URL::signedRoute('api.stock.saleunit.destroy', ['saleunit'=>$saleunit->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#delete-saleunit button.save').addClass('d-none');
              $('form#delete-saleunit button.saved').addClass('d-none');
              $('form#delete-saleunit button.error').addClass('d-none');
              $('form#delete-saleunit button.saving').removeClass('d-none');
            },
            statusCode : {
                204: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Saleunit has been deleted").'
                  })

                  $('form#delete-saleunit button.save').addClass('d-none');
                  $('form#delete-saleunit button.saved').removeClass('d-none');
                  $('form#delete-saleunit button.saving').addClass('d-none');
                  $('form#delete-saleunit button.error').addClass('d-none');
                    setTimeout(() => {
                        goto("{{ URL::signedRoute('web.stock.saleunit.index') }}");
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#delete-saleunit button.save').addClass('d-none');
              $('form#delete-saleunit button.saved').addClass('d-none');
              $('form#delete-saleunit button.saving').addClass('d-none');
              $('form#delete-saleunit button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#delete-saleunit button.save').removeClass('d-none');
                $('form#delete-saleunit button.saved').addClass('d-none');
                $('form#delete-saleunit button.saving').addClass('d-none');
                $('form#delete-saleunit button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
