<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            @include('stock.stockmove.adjust.parts.mini.finalize-btn')
            @include('stock.stockmove.adjust.parts.mini.cancel-btn')
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <div id="table"></div>
    </div>
</div>

@section('plugins.Handlebars', true)
<script id="table-template" type="text/x-handlebars-template">
    <table class="table table-sm table-bordered table-hover">
            <thead>
                <tr>
                    <th>@lang('Produto')</th>
                    <th>@lang('Quantidade')</th>
                    <th>@lang('Custo')</th>
                    <th>@lang('Armazém')</th>
                    <th>@lang('Responsável')</th>
                    <th>@lang('Cancelar')</th>
                </tr>
            </thead>
            <tbody>
            @{{#each items }}
                <tr>
                    <td>@{{ this.saleable }}</td>
                    <td>@{{ this.quantity }}</td>
                    <td>@{{ this.price }}</td>
                    <td>@{{ this.warehouse }}</td>
                    <td>@{{ this.user }}</td>
                    <td><button type="button" class="btn btn-outline-danger btn-sm delete" onclick="remove('@{{ links.self }}')">
                        <span class="badge" ><i class="fa fa-trash"></i></span>
                    </button></td>
                </tr>
            @{{/each}}

            </tbody>
        </table>
</script>
@push('js')

<script type="text/javascript">

    $(document).ready(loadItems);

    $(document).ready(checkSelectedOption);

    $('select[name="saleable"]').change(checkSelectedOption);

    function checkSelectedOption() {
        const items = JSON.parse('{!! $saleables !!}')
        const value =  $('select[name="saleable"]').val();

        let searcher = new Searchable(items)

        let saleable = searcher.data(value);
        if (saleable) {
            render(saleable)
        }
    }

    function render(saleable) {
        // console.log(saleable.)
        $('input[name="stock"]').attr('value', saleable.stock).val(saleable.stock);
        document.getElementById("stockvalue").innerHTML = parseInt(saleable.stock);
    }

    function loadItems(){
        $.ajax({
            ...ajaxSettings,
            type: "GET",
            url: "{{ URL::signedRoute('api.stock.move.index') }}",
            dataType: "JSON",
            statusCode: {
                401: (response) => {
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
            },
            success: function (response) {
                handlebar.init(response.data);
            }
        });
    }
    function remove(url){
        $.ajax({
            ...ajaxSettings,
            type: "DELETE",
            url:url,
            dataType: "JSON",
            statusCode: {
                204: loadItems,
                401: (response) => {

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                403: () => {
                    reload();
                },
            },
        });
    }

    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            if (list.length) {
                var template = Handlebars.compile($("#table-template").html());
                var context = {
                    'items': list
                };
                var html = template(context);
                this.$tableContainer.html(html);
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
@endpush
