<form role="form" class="d-inline" id="cancel-moves">
    <button type="submit" class="btn btn-sm btn-outline-danger save">@lang('Cancelar')</button>
    <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Cancelado')</button>
    <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Cancelando')</button>
    <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
</form>


@section('plugins.JqueryValidation', true)

@push('js')
<script type="text/javascript">
    $(document).ready(function () {
    $.validator.setDefaults({
        submitHandler: cancelMoves
    });

    $('#cancel-moves').validate({
        rules: {

        },
        messages: {

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
        }
    });
});


function cancelMoves() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });


    let data = $('form#cancel-moves').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'PUT',
        url: "{{ URL::signedRoute('api.stock.move.cancel') }}",
        data: data,
        beforeSend: function () {
            $('form#cancel-moves button.save').addClass('d-none');
            $('form#cancel-moves button.saved').addClass('d-none');
            $('form#cancel-moves button.error').addClass('d-none');
            $('form#cancel-moves button.saving').removeClass('d-none');
        },
        statusCode: {
            204: function (response) {
                loadItems();
                Toast.fire({
                    type: 'success',
                    title: '@lang("Entradas canceladas").'
                });

                $('form#cancel-moves button.save').addClass('d-none');
                $('form#cancel-moves button.saved').removeClass('d-none');
                $('form#cancel-moves button.saving').addClass('d-none');
                $('form#cancel-moves button.error').addClass('d-none');


            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
        },
        error: (response) => {
            $('form#cancel-moves button.save').addClass('d-none');
            $('form#cancel-moves button.saved').addClass('d-none');
            $('form#cancel-moves button.saving').addClass('d-none');
            $('form#cancel-moves button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#cancel-moves button.save').removeClass('d-none');
                $('form#cancel-moves button.saved').addClass('d-none');
                $('form#cancel-moves button.saving').addClass('d-none');
                $('form#cancel-moves button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush