<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header border-transparent">
                    <h3 class="card-title">
                        @lang('Resultados do inventário')
                    </h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div id="table" class="card-body">

                </div>
            </div>

        </div>
    </div>
</div>

<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel table table-bordered table-striped display compact">
        <thead>
            <tr>
                <th>@lang('Armazem')</th>
                <th>@lang('Categoria')</th>
                <th>@lang('Quantidade')</th>
            </tr>
        </thead>
        <tbody>
        @{{#each items }}
            <tr>
                <td>@{{ this.warehouse }}</td>
                <td>@{{ this.category }}</td>
                <td>@{{ this.quantity }}</td>
            </tr>
        @{{/each}}

        </tbody>
    </table>
</script>

@push('js')
<script type="text/javascript">
    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            var template = Handlebars.compile($("#table-template").html());
            var context = {
                'items': list
            };
            var html = template(context);
            this.$tableContainer.html(html);

            initDatatable();

            if (list.length) {
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
@endpush