<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">@lang('Detalhes de inventário')</h3>
                </div>
                <div class="card-body">
                    <form role="form" id="load-inventory">
                        <div class="row">
                            <div class="form-group col-sm-6">
                                <label for="warehouse">@lang('Armazéns')</label>
                                <select class="selectpicker form-control" data-style="btn-outline-primary"
                                    data-live-search="false" name="warehouse">
                                    @foreach ($warehouses as $warehouse)
                                    <option value="{{ $warehouse->id }}" data-tokens="{{ $warehouse->id }}">
                                        {{ $warehouse->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-sm-6">
                                <label for="category[]">@lang('Categorias')</label>
                                <select class="selectpicker form-control" multiple data-style="btn-outline-primary"
                                    data-live-search="false" name="categories[]">
                                    @foreach ($categories as $category)
                                    <option value="{{ $category->id }}" data-tokens="{{ $category->id }}">
                                        {{ $category->name }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <button type="submit"
                                    class="btn btn-sm btn-outline-primary save">@lang('Verificar')</button>

                                <a href="#" class="btn btn-sm btn-outline-primary thermal">@lang('Impressora Térmica')</a>
                                <a href="#" class="btn btn-sm btn-outline-primary a4">@lang('Impressora A4')</a>

                                <button type="button"
                                    class="btn btn-sm btn-outline-success d-none saved">@lang('Verificado')</button>
                                <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                        class="fa fa-spinner fa-spin fa-circle-notch"
                                        aria-hidden="true"></i>@lang('Verificando')</button>
                                <button type="button"
                                    class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>



@push('js')
<script type="text/javascript">

   $('a.thermal').on('click', function (event) {
        event.preventDefault()
        event.stopPropagation()
        let data = $('form#load-inventory').serialize();
        let url = '{{ URL::signedRoute('web.stock.inventory.thermal') }}&'+data
        goto(url)
   });
   $('a.a4').on('click', function (event) {
        event.preventDefault()
        event.stopPropagation()
        let data = $('form#load-inventory').serialize();
        let url = '{{ URL::signedRoute('web.stock.inventory.a4') }}&'+data
        goto(url)
   });


    $(document).ready(function () {
        $.validator.setDefaults({
            submitHandler: loadInventory
        });

        $('#load-inventory').validate({
            rules: {

            },
            messages: {
                quantity: {
                    required: 'Este campo é obrigatório',
                    min: 'Deve ser no mínimo zero'
                },
                discount: {
                    min: 'Deve ser no mínimo zero'
                },
            },
            errorElement: 'span',
            errorPlacement: function (error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function (element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function (element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });


function loadInventory() {
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    let data = $('form#load-inventory').serializeArray();

    $.ajax({
        ...ajaxSettings,
        method: 'POST',
        url: "{{ URL::signedRoute('api.stock.inventory') }}",
        data: data,
        beforeSend: function () {
            $('form#load-inventory button.save').addClass('d-none');
            $('form#load-inventory button.saved').addClass('d-none');
            $('form#load-inventory button.error').addClass('d-none');
            $('form#load-inventory button.saving').removeClass('d-none');
        },
        statusCode: {
            200: function (response) {
                Toast.fire({
                    type: 'success',
                    title: '@lang("Item added").'
                })

                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');

                handlebar.init(response.data);
            },
            401: (response) => {

                Toast.fire({
                    type: 'error',
                    title: '@lang("Volte a fazer o login").'
                })

                $.ajax({
                    url: "{{ URL::signedRoute('web.system.exit') }}",
                    dataType: "HTML",
                    success: function (response) {
                        setTimeout(() => {
                            reload();
                        }, 1500);
                    }
                });
            },
            403: () => {
                reload();
            },
            422: (response) => {
                Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                })

                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');
            },
        },
        error: (response) => {
            $('form#load-inventory button.save').addClass('d-none');
            $('form#load-inventory button.saved').addClass('d-none');
            $('form#load-inventory button.saving').addClass('d-none');
            $('form#load-inventory button.error').removeClass('d-none');
            setTimeout(() => {
                $('form#load-inventory button.save').removeClass('d-none');
                $('form#load-inventory button.saved').addClass('d-none');
                $('form#load-inventory button.saving').addClass('d-none');
                $('form#load-inventory button.error').addClass('d-none');
            }, 2000)
        }
    });
}
</script>
@endpush
