<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header border-transparent">
                    <h3 class="card-title">
                        @lang('Resultados do inventário')
                    </h3>

                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                        <button type="button" class="btn btn-tool" data-card-widget="remove">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div id="table" class="card-body">

                </div>
            </div>

        </div>
    </div>
</div>

<script id="table-template" type="text/x-handlebars-template">
    <table class="sb-datatable export excel table table-bordered table-striped display compact">
        <thead>
            <tr>
                <th>@lang('Code')</th>
                <th>@lang('Produto')</th>
                <th>@lang('Ref/Descr')</th>
                <th>@lang('Preço')</th>
                <th>@lang('Armazem')</th>
                <th>@lang('Saldo')</th>
                <th>@lang('Custo total')</th>
                <th>@lang('Fornecedor')</th>
                <th>@lang('Ultima entrada')</th>
                {{-- <th>@lang('Data de validade')</th> --}}
                <th>@lang('Usuário')</th>
            </tr>
        </thead>
        <tbody>
        @{{#each items }}
            <tr>
                <td>@{{ this.code }}</td>
                <td>@{{ this.saleable }}</td>
                <td>@{{ this.description }}</td>
                <td>@{{ this.price }}</td>
                <td>@{{ this.warehouse }}</td>
                <td>@{{ this.balance }}</td>
                <td>@{{ this.coast }}</td>
                <td>@{{ this.provider }}</td>
                <td>@{{ this.validated_at }}</td>
                {{-- <td>@{{ this.expirity_date }}</td> --}}
                <td>@{{ this.user }}</td>
            </tr>
        @{{/each}}

        </tbody>
    </table>
</script>

@push('js')
<script type="text/javascript">
    let handlebar = {
        init: function (list) {
            this.cacheDOM();
            this.render(list);
        },
        cacheDOM: function () {
            this.$tableContainer = $('#table');
        },
        render: function (list) {
            var template = Handlebars.compile($("#table-template").html());
            var context = {
                'items': list
            };
            var html = template(context);
            this.$tableContainer.html(html);

            initDatatable();

            if (list.length) {
                this.$tableContainer.parents('.card').show();
            } else {
                this.$tableContainer.parents('.card').hide();
            }
        },
    };

</script>
@endpush
