<!DOCTYPE html>
<html>

<head>
    <script type="text/javascript">
        window.print();
        window.onafterprint = home;

        function home() {
            window.location.assign("{{ URL::signedRoute('web.stock.inventory') }}");
        }
    </script>

    <style type="text/css">
        @font-face {
            font-family: 'merchant_copy_doublesizeRg';
            font-weight: normal;
            font-style: normal;
        }
    </style>
    <style type="text/css">
        * {
            margin-right: 1px;
            padding: 0px;
            /* font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif */
            font-family: 'merchant_copy_doublesizeRg';
        }


        body {
            font-size: 11px;
        }

        table {
            border: 1px solid #ccc;
            width: 100%;
            text-align: center;
        }

        table tr {
            border: 1px solid #ccc;
        }

        table tfoot td {
            /* border-left: 2px solid; */
            border-top: 2px solid;
        }
    </style>

</head>

@php
$company = $warehouse->company;
@endphp

<body>
    <div style="margin: auto; width: 200px; text-align: center">
        <img src="{{ $company->logoPhoto() }}" width="80px" height="80px" style="object-fit: scale-down;"><br>
        <b>{{ $company->name }}</b><br>
        <b>@lang('Endereco'): </b> {{ $company->address }}<br>
        <b>@lang('Nuit'): </b> {{ $company->nuit }}<br>
        <b> @lang('Inventário armazem') {{ $warehouse->name }}</b>

    </div>

    <div style="margin-top: 10px">
        <div style="width: 49%; float: left; text-align: left"><b>Data: </b>
            {{ (new Carbon\Carbon())->format('Y-m-d H:i') }}</div>
    </div>

    <div style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    {{-- <th style=" text-align: left;">@lang('Categoria')</th>
                    <th style=" text-align: right;">@lang('Quantidade').</th> --}}
                    <th>&nbsp;&nbsp;</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
            </thead>
            <tbody>

                @forelse ($categories as $category)
                {{-- <tr>
                    <td style=" text-align: left;">{{ $category->name }}</td>
                    <td style=" text-align: right;">{{ number_format($category->available, 2) }}</td>
                    <td>&nbsp;&nbsp;</td>
                    <td>&nbsp;&nbsp;</td>
                </tr> --}}

                <tr>
                    <th style=" text-align: left;">Code</th>
                    <th style=" text-align: left;">@lang('Nome') :</th>
                    <th style=" text-align: right;">Quantidade</th>
                    <th>&nbsp;&nbsp;</th>
                </tr>
                    @forelse ($category->saleables()->whereHas('stockMoves', function($query) use ($warehouse){
                        return $query->whereHas('warehouse', function($subquery)  use ($warehouse){
                            return $subquery->where('warehouses.id', $warehouse->id);
                        });

                    })->orderBy('name')->get() as $saleable)
                        @php
                            $move = $saleable->lastStockMove($warehouse);
                            if (!$move) {
                               continue;
                            }
                        @endphp

                        <tr>
                            <td style=" text-align: left;">{{ $saleable->code }}</td>
                            <td style=" text-align: left;">{{ $saleable->name }}</td>
                            <td style=" text-align: right;">{{ number_format($move->balance, 2) }}</td>
                            <td>&nbsp;&nbsp;</td>
                        </tr>
                    @empty

                    @endforelse
                @empty

                @endforelse

            </tbody>
        </table>
    </div>

    <div style="margin-top: 5px">
        <div style="width: 100%; float: left; text-align: left">
            Obrigado<br/>Volte sempre

        </div>
    </div>


    <div style="margin-top: 20px">
        <div style="width: 100%; float: left; text-align: left">
            {{ config('app.authors.name') }}<br />
            Operador: <i>{{ request()->user()->name }}</i>
        </div>
    </div>
</body>
<html>
