@extends('layouts.app')
@section('title', 'Tools List')

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>@lang('Ferramentas de Inventário')</h1>
        </div>
        {{--  <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.stock.saleable.index') }}">@lang('Produtos')</a></li>
                <li class="breadcrumb-item active">@lang('Inventário')</li>
            </ol>
        </div>  --}}
    </div>
</div>
@stop

@section('plugins.Handlebars', true)
@section('plugins.Datatables', true)
@section('plugins.DatatablesExport', true)

@section('plugins.JqueryValidation', true)
@section('plugins.Sweetalert2', true)
@section('plugins.SelectPicker', true)

@section('content')

<div class="container-fluid">
    <div class="row">
        <section class="col-md-4 connectedSortable">
            <div class="small-box bg-info">
                <div class="inner">
                    <h2>@lang('Verificador') @lang('Inventário')</h2>
                    <p>@lang('Verifique e imprima o inevatário de acordo com as categorias existentes (Docx, Excel, Pdf)')</p>
                </div>
                <div class="icon">
                    <i class="fa fa-university" aria-hidden="true"></i>
                </div>
                <a href="{{ route('web.stock.inventory') }}" class="small-box-footer "> @lang('Verificar') <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

        </section>

           <section class="col-md-4 connectedSortable">
            <div class="small-box bg-warning">
                <div class="inner">
                    <h2>@lang('Sotck por quantidade')</h2>
                    <p>@lang('Verificar produtos com stock baixos ao nivel que desejas, por quantidade')</p>
                </div>
                <div class="icon">
                   <i class="fa fa-binoculars" aria-hidden="true"></i>
                </div>
                <a href="{{ route('web.stock.tools.stock') }}" class="small-box-footer "> @lang('Verificar') <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

           </section>

           <section class="col-md-4 connectedSortable">
            <div class="small-box bg-success">
                <div class="inner">
                    <h3>@lang('verificador de Expirados')</h3>
                    <p>@lang('Produtos fora do prazo, ou mesmo dentro')<br></p>
                </div>
                <div class="icon">
                   <i class="fa fa-thermometer-full" aria-hidden="true"></i>
                </div>
                <a href="{{ route('web.stock.tools.expiredsaleable') }}" class="small-box-footer "> @lang('Verificar') <i class="fas fa-arrow-circle-right"></i>
                </a>
            </div>

        </section>
    </div>

    <div >
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                <h3>@lang('Armazéns')</h3>
                </h3>
            </div>
            <div class="card-body">
                <table id="table" class="sb-datatable table table-bordered table-striped display compact">
                    <thead>
                        <tr>
                            <th>@lang('Nome')</th>
                            <th>@lang('Produtos') Qty</th>
                            <th>@lang('Responsável')</th>
                            <th>@lang('Contacto')</th>
                        </tr>
                    </thead>
                    <tbody>

                 @foreach ($warehouses as $warehouse)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.warehouse.show', ['warehouse'=>$warehouse->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $warehouse->name }}</td>
                    <td>{{ $warehouse->saleables()->count()  }}</td>
                    <td>{{ $warehouse->responsible }}</td>
                    <td>{{ $warehouse->contact  }}</td>
                </tr>
                @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>@lang('Nome')</th>
                            <th>@lang('Produtos')</th>
                            <th>@lang('Responsável')</th>
                            <th>@lang('Contacto')</th>
                        </tr>
                    </tfoot>
                </table>
            </div>

        </div>
    </div>
</div>


@endsection

