<form role="form" id="create-warehouse">
    <div class="row">
        <div class="form-group col-sm-4">
            <label for="name">@lang('Nome')</label>
            <input type="text" name="name" class="form-control" id="name" placeholder="Total Fuels">
        </div>

        <div class="form-group col-sm-4">
            <label for="contact">@lang('Contacto')</label>
            <input type="text" name="contact" class="form-control" id="contact" placeholder="8569874565">
        </div>

        <div class="form-group col-sm-4">
          <label for="price">@lang('Usar para venda')</label>
          <br>
          <input type="checkbox" class="bootstrap-switch form-control" name="selling" checked data-bootstrap-switch
              data-off-color="danger" data-on-color="success">
      </div>

        <div class="form-group col-sm-6">
            <label for="responsible">@lang('Responsável')</label>
            <input type="text" name="responsible" class="form-control" id="responsible" placeholder="15000">
        </div>

        <div class="form-group col-sm-6">
            <label for="address">@lang('Endereço')</label>
            <input type="text" name="address" class="form-control" id="address" placeholder="Av.24 de Julho">
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
            <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
            <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                    class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
            <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
        </div>
    </div>
</form>


@section('plugins.JqueryValidation', true)
@section('plugins.BootstrapSwitch', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveCompanyData
      });

      $('#create-warehouse').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            contact:{
                required:true,
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome do item',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },
            contact:{
                required:'Introduza o codigo do produto',
            },
        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });




    function saveCompanyData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });



        let data = $('form#create-warehouse').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.stock.warehouse.store') }}",
            data: data,
            beforeSend: function(){
              $('form#create-warehouse button.save').addClass('d-none');
              $('form#create-warehouse button.saved').addClass('d-none');
              $('form#create-warehouse button.error').addClass('d-none');
              $('form#create-warehouse button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Warehouse has been created").'
                  })

                  $('form#create-warehouse button.save').addClass('d-none');
                  $('form#create-warehouse button.saved').removeClass('d-none');
                  $('form#create-warehouse button.saving').addClass('d-none');
                  $('form#create-warehouse button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#create-warehouse button.save').addClass('d-none');
              $('form#create-warehouse button.saved').addClass('d-none');
              $('form#create-warehouse button.saving').addClass('d-none');
              $('form#create-warehouse button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-warehouse button.save').removeClass('d-none');
                $('form#create-warehouse button.saved').addClass('d-none');
                $('form#create-warehouse button.saving').addClass('d-none');
                $('form#create-warehouse button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
