@section('plugins.Datatables', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@endpush


<div class="card">
    <div class="card-header">
        <h3 class="card-title">
            <a href="{{ URL::signedRoute('web.stock.warehouse.create') }}" class="btn btn-sm btn-outline-primary">
                @lang('Criar novo')</a>

            <a href="{{ URL::signedRoute('web.stock.groups.create') }}"
                class="btn btn-sm btn-outline-primary">@lang('Transferir')</a>
        </h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                      <th>@lang('Usar para venda')</th>
                    <th>@lang('Contacto')</th>
                    <th>@lang('Responsável')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($warehouses as $warehouse)
                <tr ondblclick="goto('{{ URL::signedRoute('web.stock.warehouse.show', ['warehouse'=>$warehouse->id]) }}')"
                    class="cursor-pointer">
                    <td>{{ $warehouse->name }}</td>
                    <td>{{ $warehouse->selling_werehouse  }}</td>
                    <td>{{ $warehouse->contact }}</td>
                    <td>{{ $warehouse->responsible  }}</td>
                </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                       <th>@lang('Usar para venda')</th>
                    <th>@lang('Contacto')</th>
                    <th>@lang('Responsável')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>
