<div class="container-fluid">
    <div class="row">
        <!-- left column -->
        <div class="col-md-12">
            <!-- jquery validation -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">@lang('Dados do usuario')</h3>
                </div>
                <!-- /.card-header -->
                <form role="form" id="create-user">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-sm-4">
                                <label for="name">@lang('Nome')</label>
                                <input type="text" name="name" class="form-control" id="name"
                                    placeholder="Samir">
                            </div>

                            <div class="form-group col-sm-6">
                                <label for="email">@lang('Email')</label>
                                <input type="email" name="email" class="form-control" id="email"
                                    placeholder="exemplo@mail.com">
                            </div>

                        </div>

                    </div>
                    <!-- /.card-body -->
                    <div class="card-footer">
                        <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
                        <button type="button"
                            class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
                        <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
                                class="fa fa-spinner fa-spin fa-circle-notch"
                                aria-hidden="true"></i>@lang('Salvando')</button>
                        <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
                    </div>
                </form>

            </div>
            <!-- /.card -->
        </div>
        <!--/.col (left) -->
    </div>
    <!-- /.row -->
</div>


@section('plugins.JqueryValidation', true)
@section('plugins.Select2', true)
@section('plugins.Sweetalert2', true)
@push('js')
<script type="text/javascript">
    $(document).ready(function () {
      $.validator.setDefaults({
        submitHandler: saveUserData
      });
      $('#create-user').validate({
        rules: {
            name:{
                required:true,
                minlength:2
            },
            nuit:{
                required:true,
                minlength:9,
                maxlength:9
            },
            country:{
                required:true,
                minlength:2
            },
            city:{
                required:true,
                minlength:2
            },
            email:{
                required:true,
                email: true,
            },
            phone:{
                required:true,
                minlength:2
            },
            address:{
                required:true,
                minlength:2
            },
        },
        messages: {
            name:{
                required:'Por favor introduza o nome da sucursal',
                minlength:'O nome deve ter no mínimo 2 caracteres'
            },

            email:{
                required:'Por favor introduza o email da sucursal',
                email:'Email introduzido é invalido',
            },

        },
        errorElement: 'span',
        errorPlacement: function (error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function (element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function (element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });

    $(document).ready(function () {
        $('.select2bs4').select2({
            theme: 'bootstrap4'
        })
    });


    function saveUserData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#create-user').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'POST',
            url: "{{ URL::signedRoute('api.company.brunch.users.store', ['brunch' => $brunch->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#create-user button.save').addClass('d-none');
              $('form#create-user button.saved').addClass('d-none');
              $('form#create-user button.error').addClass('d-none');
              $('form#create-user button.saving').removeClass('d-none');
            },
            statusCode : {
                201: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("New user has been created").'
                  })

                  $('form#create-user button.save').addClass('d-none');
                  $('form#create-user button.saved').removeClass('d-none');
                  $('form#create-user button.saving').addClass('d-none');
                  $('form#create-user button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })
                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#create-user button.save').addClass('d-none');
              $('form#create-user button.saved').addClass('d-none');
              $('form#create-user button.saving').addClass('d-none');
              $('form#create-user button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#create-user button.save').removeClass('d-none');
                $('form#create-user button.saved').addClass('d-none');
                $('form#create-user button.saving').addClass('d-none');
                $('form#create-user button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
