@section('plugins.Datatables', true)
@section('js')
<script type="text/javascript">
    $(document).ready(function () {
        initDatatable();
    });
</script>
@stop


<div class="card">

    @can('manage-local')
            <div class="card-header">
                    <h3 class="card-title">

                        <a href="{{ URL::signedRoute('web.company.brunch.users.create', ['brunch'=> $brunch->id]) }}"
                            class="btn btn-sm btn-outline-primary"> <i class="fa fa-user-plus" aria-hidden="true">
                                </i> @lang('Criar novo')
                     </a>

                    </h3>
                </div>
     @endcan

    <!-- /.card-header -->
    <div class="card-body">
        <table id="table" class="sb-datatable table table-bordered table-striped display compact">
            <thead>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Email')</th>
                    <th>@lang('# Roles')</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($users as $user)

                    @if (!$user->invisible)
                        <tr ondblclick="goto('{{ URL::signedRoute('web.company.brunch.users.show', ['brunch'=>$brunch->id, 'user' => $user->id]) }}')"
                            class="cursor-pointer">
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ $user->roles()->count() }}</td>
                        </tr>
                    @endif

                @endforeach

            </tbody>
            <tfoot>
                <tr>
                    <th>@lang('Nome')</th>
                    <th>@lang('Email')</th>
                    <th>@lang('# Roles')</th>
                </tr>
            </tfoot>
        </table>
    </div>
    <!-- /.card-body -->
</div>
