@extends('layouts.app')
@section('title', $user->name )

@section('content_header')
<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>{{ $user->name }}</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ URL::signedRoute('web.system.home') }}">@lang('Home')</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.company.brunch.index') }}">@lang('Sucursais')</a></li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.company.brunch.show', ['brunch' => $brunch->id]) }}">{{ $brunch->name }}</a>
                </li>
                <li class="breadcrumb-item"><a
                        href="{{ URL::signedRoute('web.company.brunch.users.index', ['brunch' => $brunch->id]) }}">@lang('Usuários')</a>
                </li>
                <li class="breadcrumb-item active">{{ $user->name }}</li>
            </ol>
        </div>
    </div>
</div>
@stop

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-3">

            @include('users.show.parts.profile')
        </div>
        <div class="col-md-9">
            @include('users.show.parts.resume')

        </div>
    </div>
</div>
@endsection
