<div class="row">
  <div class="col-12">
    <form role="form" id="edit-user-data">
      <div class="card-body">

        <div class="row">
          <div class="form-group col-sm-8">
            <label for="name">@lang('Nome')</label>
            <input type="text" name="name" class="form-control" id="name" value="{{ $user->name }}" placeholder="Tavares Alvaro">
          </div>

          <div class="form-group col-sm-4">
            <label for="email">@lang('Email')</label>
            <input type="email" name="email" class="form-control" id="email" value="{{ $user->email }}" placeholder="exemplo@mail.com">
          </div>
        </div>

      </div>
      <!-- /.card-body -->
      <div class="card-footer">
        <button type="submit" class="btn btn-sm btn-outline-primary save">@lang('Salvar')</button>
        <button type="button" class="btn btn-sm btn-outline-success d-none saved">@lang('Salvo')</button>
        <button type="button" class="btn btn-sm btn-outline-warning d-none saving"><i
            class="fa fa-spinner fa-spin fa-circle-notch" aria-hidden="true"></i>@lang('Salvando')</button>
        <button type="button" class="btn btn-sm btn-outline-danger d-none error">@lang('Erro')</button>
      </div>
    </form>
  </div>
</div>

@push('js')
<script type="text/javascript">
  $(document).ready(function () {
        $.validator.setDefaults({
          submitHandler: saveUserData
        });


        $('#edit-user-data').validate({
          rules: {

          },
          messages: {

          },
          errorElement: 'span',
          errorPlacement: function (error, element) {
            error.addClass('invalid-feedback');
            element.closest('.form-group').append(error);
          },
          highlight: function (element, errorClass, validClass) {
            $(element).addClass('is-invalid');
          },
          unhighlight: function (element, errorClass, validClass) {
            $(element).removeClass('is-invalid');
          }
        });
    });
    function saveUserData(){
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
      });


        let data = $('form#edit-user-data').serializeArray();

        $.ajax({
            ...ajaxSettings,
            method:'PUT',
            url: "{{ URL::signedRoute('api.company.brunch.users.update', ['user' => $user->id, 'brunch' => $brunch->id]) }}",
            data: data,
            beforeSend: function(){
              $('form#edit-user-data button.save').addClass('d-none');
              $('form#edit-user-data button.saved').addClass('d-none');
              $('form#edit-user-data button.error').addClass('d-none');
              $('form#edit-user-data button.saving').removeClass('d-none');
            },
            statusCode : {
                202: function(response){
                  Toast.fire({
                    type: 'success',
                    title: '@lang("Funções do usuário foram atualizadas").'
                  })

                  $('form#edit-user-data button.save').addClass('d-none');
                  $('form#edit-user-data button.saved').removeClass('d-none');
                  $('form#edit-user-data button.saving').addClass('d-none');
                  $('form#edit-user-data button.error').addClass('d-none');
                    setTimeout(() => {
                        goto(response.url.web);
                    }, 3000)
                },
                401:(response) =>{

                    Toast.fire({
                        type: 'error',
                        title: '@lang("Volte a fazer o login").'
                    })

                    $.ajax({
                        url: "{{ URL::signedRoute('web.system.exit') }}",
                        dataType: "HTML",
                        success: function (response) {
                            setTimeout(() => {
                                reload();
                            }, 1500);
                        }
                    });
                },
                422:(response) =>{
                  Toast.fire({
                    type: 'error',
                    title: '@lang("Verifique os dados inseridos e submeta outra vez").'
                  })
                },
            },
            error: (response) => {
              $('form#edit-user-data button.save').addClass('d-none');
              $('form#edit-user-data button.saved').addClass('d-none');
              $('form#edit-user-data button.saving').addClass('d-none');
              $('form#edit-user-data button.error').removeClass('d-none');
              setTimeout(() => {
                $('form#edit-user-data button.save').removeClass('d-none');
                $('form#edit-user-data button.saved').addClass('d-none');
                $('form#edit-user-data button.saving').addClass('d-none');
                $('form#edit-user-data button.error').addClass('d-none');
              }, 2000)
            }
        });
    }
</script>
@endpush
